// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.drive_explorer.v2;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.drive_explorer.v2.model.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class DriveExplorerService {

    private final Config config;
    private final Files files;
    private final Folders folders;

    public DriveExplorerService(Config config) {
        this.config = config;
        this.files = new Files(this);
        this.folders = new Folders(this);
    }

    public Files getFiles() {
        return files;
    }

    public static class Files {

        private final DriveExplorerService service;

        public Files(DriveExplorerService service) {
            this.service = service;
        }
    
        public FileCopyReqCall copy(FileCopyReqBody body, RequestOptFn... optFns) {
            return new FileCopyReqCall(this, body, optFns);
        }
    
        public FileCreateReqCall create(FileCreateReqBody body, RequestOptFn... optFns) {
            return new FileCreateReqCall(this, body, optFns);
        }
    
        public FileDocsDeleteReqCall docsDelete(RequestOptFn... optFns) {
            return new FileDocsDeleteReqCall(this, optFns);
        }
    
        public FileSpreadsheetsDeleteReqCall spreadsheetsDelete(RequestOptFn... optFns) {
            return new FileSpreadsheetsDeleteReqCall(this, optFns);
        }
    
    }
    public static class FileCopyReqCall extends ReqCaller<FileCopyReqBody, FileCopyResult> {
        private final Files files;
        
        private final FileCopyReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private FileCopyResult result;
        
        private FileCopyReqCall(Files files, FileCopyReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileCopyResult();
            this.files = files;
        }
        
        public FileCopyReqCall setFileToken(String fileToken){
            this.pathParams.put("fileToken", fileToken);
            return this;
        }

        @Override
        public Response<FileCopyResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<FileCopyReqBody, FileCopyResult> request = Request.newRequest("drive/explorer/v2/file/copy/files/:fileToken", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }
    public static class FileCreateReqCall extends ReqCaller<FileCreateReqBody, FileCreateResult> {
        private final Files files;
        
        private final FileCreateReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private FileCreateResult result;
        
        private FileCreateReqCall(Files files, FileCreateReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileCreateResult();
            this.files = files;
        }
        
        public FileCreateReqCall setFolderToken(String folderToken){
            this.pathParams.put("folderToken", folderToken);
            return this;
        }

        @Override
        public Response<FileCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<FileCreateReqBody, FileCreateResult> request = Request.newRequest("drive/explorer/v2/file/:folderToken", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }
    public static class FileDocsDeleteReqCall extends ReqCaller<Object, FileDocsDeleteResult> {
        private final Files files;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private FileDocsDeleteResult result;
        
        private FileDocsDeleteReqCall(Files files, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileDocsDeleteResult();
            this.files = files;
        }
        
        public FileDocsDeleteReqCall setDocToken(String docToken){
            this.pathParams.put("docToken", docToken);
            return this;
        }

        @Override
        public Response<FileDocsDeleteResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, FileDocsDeleteResult> request = Request.newRequest("drive/explorer/v2/file/docs/:docToken", "DELETE",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }
    public static class FileSpreadsheetsDeleteReqCall extends ReqCaller<Object, FileSpreadsheetsDeleteResult> {
        private final Files files;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private FileSpreadsheetsDeleteResult result;
        
        private FileSpreadsheetsDeleteReqCall(Files files, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FileSpreadsheetsDeleteResult();
            this.files = files;
        }
        
        public FileSpreadsheetsDeleteReqCall setSpreadsheetToken(String spreadsheetToken){
            this.pathParams.put("spreadsheetToken", spreadsheetToken);
            return this;
        }

        @Override
        public Response<FileSpreadsheetsDeleteResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, FileSpreadsheetsDeleteResult> request = Request.newRequest("drive/explorer/v2/file/spreadsheets/:spreadsheetToken", "DELETE",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.files.service.config, request);
        }
    }

    public Folders getFolders() {
        return folders;
    }

    public static class Folders {

        private final DriveExplorerService service;

        public Folders(DriveExplorerService service) {
            this.service = service;
        }
    
        public FolderChildrenReqCall children(RequestOptFn... optFns) {
            return new FolderChildrenReqCall(this, optFns);
        }
    
        public FolderCreateReqCall create(FolderCreateReqBody body, RequestOptFn... optFns) {
            return new FolderCreateReqCall(this, body, optFns);
        }
    
        public FolderMetaReqCall meta(RequestOptFn... optFns) {
            return new FolderMetaReqCall(this, optFns);
        }
    
        public FolderRootMetaReqCall rootMeta(RequestOptFn... optFns) {
            return new FolderRootMetaReqCall(this, optFns);
        }
    
    }
    public static class FolderChildrenReqCall extends ReqCaller<Object, FolderChildrenResult> {
        private final Folders folders;
        
        private final Map<String, Object> pathParams;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private FolderChildrenResult result;
        
        private FolderChildrenReqCall(Folders folders, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FolderChildrenResult();
            this.folders = folders;
        }
        
        public FolderChildrenReqCall setFolderToken(String folderToken){
            this.pathParams.put("folderToken", folderToken);
            return this;
        }
        
        public FolderChildrenReqCall setTypes(String... types){
            this.queryParams.put("types", types);
            return this;
        }

        @Override
        public Response<FolderChildrenResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, FolderChildrenResult> request = Request.newRequest("drive/explorer/v2/folder/:folderToken/children", "GET",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.folders.service.config, request);
        }
    }
    public static class FolderCreateReqCall extends ReqCaller<FolderCreateReqBody, FolderCreateResult> {
        private final Folders folders;
        
        private final FolderCreateReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private FolderCreateResult result;
        
        private FolderCreateReqCall(Folders folders, FolderCreateReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FolderCreateResult();
            this.folders = folders;
        }
        
        public FolderCreateReqCall setFolderToken(String folderToken){
            this.pathParams.put("folderToken", folderToken);
            return this;
        }

        @Override
        public Response<FolderCreateResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<FolderCreateReqBody, FolderCreateResult> request = Request.newRequest("drive/explorer/v2/folder/:folderToken", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.folders.service.config, request);
        }
    }
    public static class FolderMetaReqCall extends ReqCaller<Object, FolderMetaResult> {
        private final Folders folders;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private FolderMetaResult result;
        
        private FolderMetaReqCall(Folders folders, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FolderMetaResult();
            this.folders = folders;
        }
        
        public FolderMetaReqCall setFolderToken(String folderToken){
            this.pathParams.put("folderToken", folderToken);
            return this;
        }

        @Override
        public Response<FolderMetaResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, FolderMetaResult> request = Request.newRequest("drive/explorer/v2/folder/:folderToken/meta", "GET",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.folders.service.config, request);
        }
    }
    public static class FolderRootMetaReqCall extends ReqCaller<Object, FolderRootMetaResult> {
        private final Folders folders;
        
        private final List<RequestOptFn> optFns;
        private FolderRootMetaResult result;
        
        private FolderRootMetaReqCall(Folders folders, RequestOptFn... optFns) {
        
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FolderRootMetaResult();
            this.folders = folders;
        }
        

        @Override
        public Response<FolderRootMetaResult> execute() throws Exception {
            Request<Object, FolderRootMetaResult> request = Request.newRequest("drive/explorer/v2/root_folder/meta", "GET",
                    new AccessTokenType[]{AccessTokenType.User},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.folders.service.config, request);
        }
    }

}
