// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.ehr.v1;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.ehr.v1.model.*;
import java.io.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class EhrService {

    private final Config config;
    private final Attachments attachments;
    private final Employees employees;

    public EhrService(Config config) {
        this.config = config;
        this.attachments = new Attachments(this);
        this.employees = new Employees(this);
    }

    public Attachments getAttachments() {
        return attachments;
    }

    public static class Attachments {

        private final EhrService service;

        public Attachments(EhrService service) {
            this.service = service;
        }
    
        public AttachmentGetReqCall get(RequestOptFn... optFns) {
            return new AttachmentGetReqCall(this, optFns);
        }
    
    }
    public static class AttachmentGetReqCall extends ReqCaller<Object, OutputStream> {
        private final Attachments attachments;
        
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private OutputStream result;
        
        private AttachmentGetReqCall(Attachments attachments, RequestOptFn... optFns) {
        
            this.pathParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.attachments = attachments;
        }
        
        public AttachmentGetReqCall setToken(String token){
            this.pathParams.put("token", token);
            return this;
        }
        public AttachmentGetReqCall setResponseStream(OutputStream result){
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("ehr/v1/attachments/:token", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.attachments.service.config, request);
        }
    }

    public Employees getEmployees() {
        return employees;
    }

    public static class Employees {

        private final EhrService service;

        public Employees(EhrService service) {
            this.service = service;
        }
    
        public EmployeeListReqCall list(RequestOptFn... optFns) {
            return new EmployeeListReqCall(this, optFns);
        }
    
    }
    public static class EmployeeListReqCall extends ReqCaller<Object, EmployeeListResult> {
        private final Employees employees;
        
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private EmployeeListResult result;
        
        private EmployeeListReqCall(Employees employees, RequestOptFn... optFns) {
        
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmployeeListResult();
            this.employees = employees;
        }
        
        
        public EmployeeListReqCall setView(String view){
            this.queryParams.put("view", view);
            return this;
        }
        public EmployeeListReqCall setStatus(Integer... status){
            this.queryParams.put("status", status);
            return this;
        }
        public EmployeeListReqCall setType(Integer... type){
            this.queryParams.put("type", type);
            return this;
        }
        public EmployeeListReqCall setStartTime(Integer startTime){
            this.queryParams.put("start_time", startTime);
            return this;
        }
        public EmployeeListReqCall setEndTime(Integer endTime){
            this.queryParams.put("end_time", endTime);
            return this;
        }
        public EmployeeListReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }
        public EmployeeListReqCall setUserIds(String userIds){
            this.queryParams.put("user_ids", userIds);
            return this;
        }
        public EmployeeListReqCall setPageToken(String pageToken){
            this.queryParams.put("page_token", pageToken);
            return this;
        }
        public EmployeeListReqCall setPageSize(Integer pageSize){
            this.queryParams.put("page_size", pageSize);
            return this;
        }

        @Override
        public Response<EmployeeListResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, EmployeeListResult> request = Request.newRequest("ehr/v1/employees", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.employees.service.config, request);
        }
    }

}
