// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.face_verify.v1;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.face_verify.v1.model.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class FaceVerifyService {

    private final Config config;
    private final FaceVerifys faceVerifys;

    public FaceVerifyService(Config config) {
        this.config = config;
        this.faceVerifys = new FaceVerifys(this);
    }

    public FaceVerifys getFaceVerifys() {
        return faceVerifys;
    }

    public static class FaceVerifys {

        private final FaceVerifyService service;

        public FaceVerifys(FaceVerifyService service) {
            this.service = service;
        }
    
        public FaceVerifyCropFaceImageReqCall cropFaceImage(RequestOptFn... optFns) {
            return new FaceVerifyCropFaceImageReqCall(this, optFns);
        }
    
        public FaceVerifyQueryAuthResultReqCall queryAuthResult(RequestOptFn... optFns) {
            return new FaceVerifyQueryAuthResultReqCall(this, optFns);
        }
    
        public FaceVerifyUploadFaceImageReqCall uploadFaceImage(RequestOptFn... optFns) {
            return new FaceVerifyUploadFaceImageReqCall(this, optFns);
        }
    
    }
    public static class FaceVerifyCropFaceImageReqCall extends ReqCaller<FormData, FaceVerifyCropFaceImageResult> {
        private final FaceVerifys faceVerifys;
        private final FormData body;
        private final List<RequestOptFn> optFns;
        private FaceVerifyCropFaceImageResult result;
        
        private FaceVerifyCropFaceImageReqCall(FaceVerifys faceVerifys, RequestOptFn... optFns) {
        
            this.body = new FormData();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FaceVerifyCropFaceImageResult();
            this.faceVerifys = faceVerifys;
        }
        
        
        public FaceVerifyCropFaceImageReqCall setRawImage(FormDataFile rawImage){
            this.body.addFile("raw_image", rawImage);
            return this;
        }
        

        @Override
        public Response<FaceVerifyCropFaceImageResult> execute() throws Exception {
            Request<FormData, FaceVerifyCropFaceImageResult> request = Request.newRequest("face_verify/v1/crop_face_image", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.faceVerifys.service.config, request);
        }
    }
    public static class FaceVerifyQueryAuthResultReqCall extends ReqCaller<Object, FaceVerifyQueryAuthResultResult> {
        private final FaceVerifys faceVerifys;
        
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private FaceVerifyQueryAuthResultResult result;
        
        private FaceVerifyQueryAuthResultReqCall(FaceVerifys faceVerifys, RequestOptFn... optFns) {
        
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FaceVerifyQueryAuthResultResult();
            this.faceVerifys = faceVerifys;
        }
        
        
        public FaceVerifyQueryAuthResultReqCall setReqOrderNo(String reqOrderNo){
            this.queryParams.put("req_order_no", reqOrderNo);
            return this;
        }
        public FaceVerifyQueryAuthResultReqCall setOpenId(String openId){
            this.queryParams.put("open_id", openId);
            return this;
        }
        public FaceVerifyQueryAuthResultReqCall setEmployeeId(String employeeId){
            this.queryParams.put("employee_id", employeeId);
            return this;
        }

        @Override
        public Response<FaceVerifyQueryAuthResultResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<Object, FaceVerifyQueryAuthResultResult> request = Request.newRequest("face_verify/v1/query_auth_result", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.faceVerifys.service.config, request);
        }
    }
    public static class FaceVerifyUploadFaceImageReqCall extends ReqCaller<FormData, FaceVerifyUploadFaceImageResult> {
        private final FaceVerifys faceVerifys;
        private final FormData body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private FaceVerifyUploadFaceImageResult result;
        
        private FaceVerifyUploadFaceImageReqCall(FaceVerifys faceVerifys, RequestOptFn... optFns) {
        
            this.body = new FormData();
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new FaceVerifyUploadFaceImageResult();
            this.faceVerifys = faceVerifys;
        }
        
        
        public FaceVerifyUploadFaceImageReqCall setOpenId(String openId){
            this.queryParams.put("open_id", openId);
            return this;
        }
        public FaceVerifyUploadFaceImageReqCall setEmployeeId(String employeeId){
            this.queryParams.put("employee_id", employeeId);
            return this;
        }
        
        public FaceVerifyUploadFaceImageReqCall setImage(FormDataFile image){
            this.body.addFile("image", image);
            return this;
        }
        

        @Override
        public Response<FaceVerifyUploadFaceImageResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<FormData, FaceVerifyUploadFaceImageResult> request = Request.newRequest("face_verify/v1/upload_face_image", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.faceVerifys.service.config, request);
        }
    }

}
