// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.human_authentication.v1;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.human_authentication.v1.model.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class HumanAuthenticationService {

    private final Config config;
    private final Identitys identitys;

    public HumanAuthenticationService(Config config) {
        this.config = config;
        this.identitys = new Identitys(this);
    }

    public Identitys getIdentitys() {
        return identitys;
    }

    public static class Identitys {

        private final HumanAuthenticationService service;

        public Identitys(HumanAuthenticationService service) {
            this.service = service;
        }
    
        public IdentityCreateReqCall create(IdentityCreateReqBody body, RequestOptFn... optFns) {
            return new IdentityCreateReqCall(this, body, optFns);
        }
    
    }
    public static class IdentityCreateReqCall extends ReqCaller<IdentityCreateReqBody, IdentityCreateResult> {
        private final Identitys identitys;
        
        private final IdentityCreateReqBody body;
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private IdentityCreateResult result;
        
        private IdentityCreateReqCall(Identitys identitys, IdentityCreateReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new IdentityCreateResult();
            this.identitys = identitys;
        }
        
        
        public IdentityCreateReqCall setUserId(String userId){
            this.queryParams.put("user_id", userId);
            return this;
        }
        public IdentityCreateReqCall setUserIdType(String userIdType){
            this.queryParams.put("user_id_type", userIdType);
            return this;
        }

        @Override
        public Response<IdentityCreateResult> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            Request<IdentityCreateReqBody, IdentityCreateResult> request = Request.newRequest("human_authentication/v1/identities", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.identitys.service.config, request);
        }
    }

}
