// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.image.v4;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.image.v4.model.*;
import java.io.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class ImageService {

    private final Config config;
    private final Images images;

    public ImageService(Config config) {
        this.config = config;
        this.images = new Images(this);
    }

    public Images getImages() {
        return images;
    }

    public static class Images {

        private final ImageService service;

        public Images(ImageService service) {
            this.service = service;
        }
    
        public ImageGetReqCall get(RequestOptFn... optFns) {
            return new ImageGetReqCall(this, optFns);
        }
    
        public ImagePutReqCall put(RequestOptFn... optFns) {
            return new ImagePutReqCall(this, optFns);
        }
    
    }
    public static class ImageGetReqCall extends ReqCaller<Object, OutputStream> {
        private final Images images;
        
        private final Map<String, Object> queryParams;
        private final List<RequestOptFn> optFns;
        private OutputStream result;
        
        private ImageGetReqCall(Images images, RequestOptFn... optFns) {
        
            this.queryParams = new HashMap<>();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.images = images;
        }
        
        
        public ImageGetReqCall setImageKey(String imageKey){
            this.queryParams.put("image_key", imageKey);
            return this;
        }
        public ImageGetReqCall setResponseStream(OutputStream result){
            this.result = result;
            return this;
        }

        @Override
        public Response<OutputStream> execute() throws Exception {
            this.optFns.add(Request.setQueryParams(this.queryParams));
            this.optFns.add(Request.setResponseStream());
            Request<Object, OutputStream> request = Request.newRequest("image/v4/get", "GET",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    null, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.images.service.config, request);
        }
    }
    public static class ImagePutReqCall extends ReqCaller<FormData, Image> {
        private final Images images;
        private final FormData body;
        private final List<RequestOptFn> optFns;
        private Image result;
        
        private ImagePutReqCall(Images images, RequestOptFn... optFns) {
        
            this.body = new FormData();
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new Image();
            this.images = images;
        }
        
        
        public ImagePutReqCall setImage(FormDataFile image){
            this.body.addFile("image", image);
            return this;
        }
        
        public ImagePutReqCall setImageType(String imageType){
            this.body.addField("image_type", imageType);
            return this;
        }
        

        @Override
        public Response<Image> execute() throws Exception {
            Request<FormData, Image> request = Request.newRequest("image/v4/put", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.images.service.config, request);
        }
    }

}
