// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.optical_char_recognition.v1;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.optical_char_recognition.v1.model.*;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class OpticalCharRecognitionService {

    private final Config config;
    private final Images images;

    public OpticalCharRecognitionService(Config config) {
        this.config = config;
        this.images = new Images(this);
    }

    public Images getImages() {
        return images;
    }

    public static class Images {

        private final OpticalCharRecognitionService service;

        public Images(OpticalCharRecognitionService service) {
            this.service = service;
        }
    
        public ImageBasicRecognizeReqCall basicRecognize(ImageBasicRecognizeReqBody body, RequestOptFn... optFns) {
            return new ImageBasicRecognizeReqCall(this, body, optFns);
        }
    
    }
    public static class ImageBasicRecognizeReqCall extends ReqCaller<ImageBasicRecognizeReqBody, ImageBasicRecognizeResult> {
        private final Images images;
        
        private final ImageBasicRecognizeReqBody body;
        private final List<RequestOptFn> optFns;
        private ImageBasicRecognizeResult result;
        
        private ImageBasicRecognizeReqCall(Images images, ImageBasicRecognizeReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new ImageBasicRecognizeResult();
            this.images = images;
        }
        

        @Override
        public Response<ImageBasicRecognizeResult> execute() throws Exception {
            Request<ImageBasicRecognizeReqBody, ImageBasicRecognizeResult> request = Request.newRequest("optical_char_recognition/v1/image/basic_recognize", "POST",
                    new AccessTokenType[]{AccessTokenType.Tenant},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.images.service.config, request);
        }
    }

}
