// Code generated by lark suite oapi sdk gen
package com.larksuite.oapi.service.suite.v1;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.*;
import com.larksuite.oapi.core.api.response.*;
import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.service.suite.v1.model.*;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class SuiteService {

    private final Config config;
    private final DocsApis docsApis;

    public SuiteService(Config config) {
        this.config = config;
        this.docsApis = new DocsApis(this);
    }

    public DocsApis getDocsApis() {
        return docsApis;
    }

    public static class DocsApis {

        private final SuiteService service;

        public DocsApis(SuiteService service) {
            this.service = service;
        }
    
        public DocsApiMetaReqCall meta(DocsApiMetaReqBody body, RequestOptFn... optFns) {
            return new DocsApiMetaReqCall(this, body, optFns);
        }
    
        public DocsApiSearchReqCall search(DocsApiSearchReqBody body, RequestOptFn... optFns) {
            return new DocsApiSearchReqCall(this, body, optFns);
        }
    
    }
    public static class DocsApiMetaReqCall extends ReqCaller<DocsApiMetaReqBody, DocsApiMetaResult> {
        private final DocsApis docsApis;
        
        private final DocsApiMetaReqBody body;
        private final List<RequestOptFn> optFns;
        private DocsApiMetaResult result;
        
        private DocsApiMetaReqCall(DocsApis docsApis, DocsApiMetaReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DocsApiMetaResult();
            this.docsApis = docsApis;
        }
        

        @Override
        public Response<DocsApiMetaResult> execute() throws Exception {
            Request<DocsApiMetaReqBody, DocsApiMetaResult> request = Request.newRequest("suite/docs_api/meta", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.docsApis.service.config, request);
        }
    }
    public static class DocsApiSearchReqCall extends ReqCaller<DocsApiSearchReqBody, DocsApiSearchResult> {
        private final DocsApis docsApis;
        
        private final DocsApiSearchReqBody body;
        private final List<RequestOptFn> optFns;
        private DocsApiSearchResult result;
        
        private DocsApiSearchReqCall(DocsApis docsApis, DocsApiSearchReqBody body, RequestOptFn... optFns) {
        
            this.body = body;
            this.optFns = new ArrayList<>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DocsApiSearchResult();
            this.docsApis = docsApis;
        }
        

        @Override
        public Response<DocsApiSearchResult> execute() throws Exception {
            Request<DocsApiSearchReqBody, DocsApiSearchResult> request = Request.newRequest("suite/docs_api/search/object", "POST",
                    new AccessTokenType[]{AccessTokenType.User},
                    this.body, this.result, this.optFns.toArray(new RequestOptFn[]{}));
            return Api.send(this.docsApis.service.config, request);
        }
    }

}
