/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core.api;

import com.larksuite.oapi.core.api.ReqCallResult;
import com.larksuite.oapi.core.api.ReqCaller;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class BatchReqCall<I, O> {
    private static final ExecutorService defaultExecutorService = Executors.newCachedThreadPool(new ThreadFactory(){
        protected final AtomicInteger mThreadNum = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable runnable) {
            String mPrefix = "larksuite-oapi-thread-";
            String name = mPrefix + this.mThreadNum.getAndIncrement();
            return new Thread(null, runnable, name, 0L);
        }
    });
    private final ExecutorService executorService;
    private final List<ReqCaller<I, O>> reqCallers;

    @SafeVarargs
    public BatchReqCall(ReqCaller<I, O> ... reqCallers) {
        this(defaultExecutorService, reqCallers);
    }

    @SafeVarargs
    public BatchReqCall(ExecutorService executorService, ReqCaller<I, O> ... reqCallers) {
        this.executorService = executorService;
        this.reqCallers = new ArrayList<ReqCaller<I, O>>();
        int i = 0;
        for (ReqCaller<I, O> reqCaller : reqCallers) {
            reqCaller.setIdx$$(i);
            this.reqCallers.add(reqCaller);
            ++i;
        }
    }

    public List<ReqCallResult<I, O>> call() throws InterruptedException, ExecutionException {
        ArrayList<ReqCallResult<I, O>> reqCallResults = new ArrayList<ReqCallResult<I, O>>();
        if (this.reqCallers.size() == 0) {
            return reqCallResults;
        }
        List futures = this.executorService.invokeAll(this.reqCallers);
        for (Future future : futures) {
            ReqCallResult reqCallResult = new ReqCallResult((ReqCaller)future.get());
            reqCallResults.add(reqCallResult);
        }
        reqCallResults.sort(Comparator.comparingInt(o -> o.getReqCaller().getIdx$$()));
        return reqCallResults;
    }
}

