/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.core.api.request;

import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.request.BaseRequest;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.request.requestoptfn.NotDataField;
import com.larksuite.oapi.core.api.request.requestoptfn.PathParams;
import com.larksuite.oapi.core.api.request.requestoptfn.QueryParams;
import com.larksuite.oapi.core.api.request.requestoptfn.ResponseStream;
import com.larksuite.oapi.core.api.request.requestoptfn.SupportLongDatatype;
import com.larksuite.oapi.core.api.request.requestoptfn.TenantKey;
import com.larksuite.oapi.core.api.request.requestoptfn.Timeout;
import com.larksuite.oapi.core.api.request.requestoptfn.UserAccessToken;
import com.larksuite.oapi.okhttp3_14.Request;
import com.larksuite.oapi.okhttp3_14.Response;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Request<I, O>
extends BaseRequest<I, O> {
    private Request.Builder httpRequestBuilder;
    private Response httpResponse;
    private byte[] requestBody;
    private String requestBodyFilePath;
    private InputStream requestBodyStream;
    private String contentType;
    private com.larksuite.oapi.core.api.response.Response<O> response;

    private Request(String httpPath, String httpMethod, AccessTokenType accessTokenType, I input, O output, RequestOptFn ... requestOptFns) {
        super(httpPath, httpMethod, accessTokenType, input, output, requestOptFns);
    }

    private Request(String httpPath, String httpMethod, AccessTokenType[] accessTokenTypes, I input, O output, RequestOptFn ... requestOptFns) {
        super(httpPath, httpMethod, accessTokenTypes, input, output, requestOptFns);
    }

    public static <I, O> Request<I, O> newRequestByAuth(String httpPath, String httpMethod, I input, O output) {
        return new Request<I, O>(httpPath, httpMethod, AccessTokenType.None, input, output, Request.setNotDataField());
    }

    public static <I, O> Request<I, O> newRequest(String httpPath, String httpMethod, AccessTokenType[] accessTokenTypes, I input, O output, RequestOptFn ... requestOptFns) {
        return new Request<I, O>(httpPath, httpMethod, accessTokenTypes, input, output, requestOptFns);
    }

    public static <I, O> Request<I, O> newRequest(String httpPath, String httpMethod, AccessTokenType accessTokenType, I input, O output, RequestOptFn ... requestOptFns) {
        return Request.newRequest(httpPath, httpMethod, new AccessTokenType[]{accessTokenType}, input, output, requestOptFns);
    }

    public static RequestOptFn setNotDataField() {
        return new NotDataField();
    }

    public static RequestOptFn setResponseStream() {
        return new ResponseStream();
    }

    public static RequestOptFn setTimeout(int time, TimeUnit timeUnit) {
        return new Timeout(time, timeUnit);
    }

    public static RequestOptFn setPathParams(Map<String, Object> pathParams) {
        return new PathParams(pathParams);
    }

    public static RequestOptFn setQueryParams(Map<String, Object> queryParams) {
        return new QueryParams(queryParams);
    }

    public static RequestOptFn setTenantKey(String tenantKey) {
        return new TenantKey(tenantKey);
    }

    public static RequestOptFn setUserAccessToken(String userAccessToken) {
        return new UserAccessToken(userAccessToken);
    }

    public static RequestOptFn setSupportLongDataType() {
        return new SupportLongDatatype();
    }

    public String toString() {
        return this.getHttpMethod() + " " + this.url() + " " + (Object)((Object)this.getAccessTokenType());
    }

    public Request.Builder getHttpRequestBuilder() {
        return this.httpRequestBuilder;
    }

    public void setHttpRequestBuilder(Request.Builder httpRequestBuilder) {
        this.httpRequestBuilder = httpRequestBuilder;
    }

    public Response getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(Response httpResponse) {
        this.httpResponse = httpResponse;
    }

    public String getRequestBodyFilePath() {
        return this.requestBodyFilePath;
    }

    public void setRequestBodyFilePath(String requestBodyFilePath) {
        this.requestBodyFilePath = requestBodyFilePath;
    }

    public byte[] getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(byte[] requestBody) {
        this.requestBody = requestBody;
    }

    public InputStream getRequestBodyStream() {
        return this.requestBodyStream;
    }

    public void setRequestBodyStream(InputStream requestBodyStream) {
        this.requestBodyStream = requestBodyStream;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public com.larksuite.oapi.core.api.response.Response<O> getResponse() {
        return this.response;
    }

    public void setResponse(com.larksuite.oapi.core.api.response.Response<O> response) {
        this.response = response;
    }
}

