/*
 * Decompiled with CFR 0.152.
 */
package com.larksuite.oapi.service.doc.v2;

import com.larksuite.oapi.core.Config;
import com.larksuite.oapi.core.api.AccessTokenType;
import com.larksuite.oapi.core.api.Api;
import com.larksuite.oapi.core.api.ReqCaller;
import com.larksuite.oapi.core.api.request.Request;
import com.larksuite.oapi.core.api.request.RequestOptFn;
import com.larksuite.oapi.core.api.response.EmptyData;
import com.larksuite.oapi.core.api.response.Response;
import com.larksuite.oapi.service.doc.v2.model.DocBatchUpdateReqBody;
import com.larksuite.oapi.service.doc.v2.model.DocContentResult;
import com.larksuite.oapi.service.doc.v2.model.DocCreateReqBody;
import com.larksuite.oapi.service.doc.v2.model.DocCreateResult;
import com.larksuite.oapi.service.doc.v2.model.DocMetaResult;
import com.larksuite.oapi.service.doc.v2.model.DocRawContentResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocService {
    private final Config config;
    private final Docs docs;

    public DocService(Config config) {
        this.config = config;
        this.docs = new Docs(this);
    }

    public Docs getDocs() {
        return this.docs;
    }

    public static class DocRawContentReqCall
    extends ReqCaller<Object, DocRawContentResult> {
        private final Docs docs;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DocRawContentResult result;

        private DocRawContentReqCall(Docs docs, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DocRawContentResult();
            this.docs = docs;
        }

        public DocRawContentReqCall setDocToken(String docToken) {
            this.pathParams.put("docToken", docToken);
            return this;
        }

        @Override
        public Response<DocRawContentResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, DocRawContentResult> request = Request.newRequest("doc/v2/:docToken/raw_content", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.docs.service.config, request);
        }
    }

    public static class DocMetaReqCall
    extends ReqCaller<Object, DocMetaResult> {
        private final Docs docs;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DocMetaResult result;

        private DocMetaReqCall(Docs docs, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DocMetaResult();
            this.docs = docs;
        }

        public DocMetaReqCall setDocToken(String docToken) {
            this.pathParams.put("docToken", docToken);
            return this;
        }

        @Override
        public Response<DocMetaResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, DocMetaResult> request = Request.newRequest("doc/v2/meta/:docToken", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.docs.service.config, request);
        }
    }

    public static class DocCreateReqCall
    extends ReqCaller<DocCreateReqBody, DocCreateResult> {
        private final Docs docs;
        private final DocCreateReqBody body;
        private final List<RequestOptFn> optFns;
        private DocCreateResult result;

        private DocCreateReqCall(Docs docs, DocCreateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DocCreateResult();
            this.docs = docs;
        }

        @Override
        public Response<DocCreateResult> execute() throws Exception {
            Request<DocCreateReqBody, DocCreateResult> request = Request.newRequest("doc/v2/create", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.docs.service.config, request);
        }
    }

    public static class DocContentReqCall
    extends ReqCaller<Object, DocContentResult> {
        private final Docs docs;
        private final Map<String, Object> pathParams = new HashMap<String, Object>();
        private final List<RequestOptFn> optFns = new ArrayList<RequestOptFn>();
        private DocContentResult result;

        private DocContentReqCall(Docs docs, RequestOptFn ... optFns) {
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new DocContentResult();
            this.docs = docs;
        }

        public DocContentReqCall setDocToken(String docToken) {
            this.pathParams.put("docToken", docToken);
            return this;
        }

        @Override
        public Response<DocContentResult> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<Object, DocContentResult> request = Request.newRequest("doc/v2/:docToken/content", "GET", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, null, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.docs.service.config, request);
        }
    }

    public static class DocBatchUpdateReqCall
    extends ReqCaller<DocBatchUpdateReqBody, EmptyData> {
        private final Docs docs;
        private final DocBatchUpdateReqBody body;
        private final Map<String, Object> pathParams;
        private final List<RequestOptFn> optFns;
        private EmptyData result;

        private DocBatchUpdateReqCall(Docs docs, DocBatchUpdateReqBody body, RequestOptFn ... optFns) {
            this.body = body;
            this.pathParams = new HashMap<String, Object>();
            this.optFns = new ArrayList<RequestOptFn>();
            this.optFns.addAll(Arrays.asList(optFns));
            this.result = new EmptyData();
            this.docs = docs;
        }

        public DocBatchUpdateReqCall setDocToken(String docToken) {
            this.pathParams.put("docToken", docToken);
            return this;
        }

        @Override
        public Response<EmptyData> execute() throws Exception {
            this.optFns.add(Request.setPathParams(this.pathParams));
            Request<DocBatchUpdateReqBody, EmptyData> request = Request.newRequest("doc/v2/:docToken/batch_update", "POST", new AccessTokenType[]{AccessTokenType.User, AccessTokenType.Tenant}, this.body, this.result, this.optFns.toArray(new RequestOptFn[0]));
            return Api.send(this.docs.service.config, request);
        }
    }

    public static class Docs {
        private final DocService service;

        public Docs(DocService service) {
            this.service = service;
        }

        public DocBatchUpdateReqCall batchUpdate(DocBatchUpdateReqBody body, RequestOptFn ... optFns) {
            return new DocBatchUpdateReqCall(this, body, optFns);
        }

        public DocContentReqCall content(RequestOptFn ... optFns) {
            return new DocContentReqCall(this, optFns);
        }

        public DocCreateReqCall create(DocCreateReqBody body, RequestOptFn ... optFns) {
            return new DocCreateReqCall(this, body, optFns);
        }

        public DocMetaReqCall meta(RequestOptFn ... optFns) {
            return new DocMetaReqCall(this, optFns);
        }

        public DocRawContentReqCall rawContent(RequestOptFn ... optFns) {
            return new DocRawContentReqCall(this, optFns);
        }
    }
}

