// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.google.gson.annotations.SerializedName;

public class TaskResult {
    /**
     * 上班打卡记录 ID
     * <p> 示例值：6709359313699356941
     */
    @SerializedName("check_in_record_id")
    private String checkInRecordId;
    /**
     * 上班打卡记录
     * <p> 示例值：
     */
    @SerializedName("check_in_record")
    private UserFlow checkInRecord;
    /**
     * 下班打卡记录 ID
     * <p> 示例值：6709359313699356942
     */
    @SerializedName("check_out_record_id")
    private String checkOutRecordId;
    /**
     * 下班打卡记录
     * <p> 示例值：
     */
    @SerializedName("check_out_record")
    private UserFlow checkOutRecord;
    /**
     * 上班打卡结果
     * <p> 示例值：SystemCheck
     */
    @SerializedName("check_in_result")
    private String checkInResult;
    /**
     * 下班打卡结果
     * <p> 示例值：SystemCheck
     */
    @SerializedName("check_out_result")
    private String checkOutResult;
    /**
     * 上班打卡结果补充
     * <p> 示例值：None
     */
    @SerializedName("check_in_result_supplement")
    private String checkInResultSupplement;
    /**
     * 下班打卡结果补充
     * <p> 示例值：None
     */
    @SerializedName("check_out_result_supplement")
    private String checkOutResultSupplement;
    /**
     * 上班打卡时间
     * <p> 示例值：1609722000
     */
    @SerializedName("check_in_shift_time")
    private String checkInShiftTime;
    /**
     * 下班打卡时间
     * <p> 示例值：1609754400
     */
    @SerializedName("check_out_shift_time")
    private String checkOutShiftTime;

    // builder 开始
    public TaskResult() {
    }

    public TaskResult(Builder builder) {
        /**
         * 上班打卡记录 ID
         * <p> 示例值：6709359313699356941
         */
        this.checkInRecordId = builder.checkInRecordId;
        /**
         * 上班打卡记录
         * <p> 示例值：
         */
        this.checkInRecord = builder.checkInRecord;
        /**
         * 下班打卡记录 ID
         * <p> 示例值：6709359313699356942
         */
        this.checkOutRecordId = builder.checkOutRecordId;
        /**
         * 下班打卡记录
         * <p> 示例值：
         */
        this.checkOutRecord = builder.checkOutRecord;
        /**
         * 上班打卡结果
         * <p> 示例值：SystemCheck
         */
        this.checkInResult = builder.checkInResult;
        /**
         * 下班打卡结果
         * <p> 示例值：SystemCheck
         */
        this.checkOutResult = builder.checkOutResult;
        /**
         * 上班打卡结果补充
         * <p> 示例值：None
         */
        this.checkInResultSupplement = builder.checkInResultSupplement;
        /**
         * 下班打卡结果补充
         * <p> 示例值：None
         */
        this.checkOutResultSupplement = builder.checkOutResultSupplement;
        /**
         * 上班打卡时间
         * <p> 示例值：1609722000
         */
        this.checkInShiftTime = builder.checkInShiftTime;
        /**
         * 下班打卡时间
         * <p> 示例值：1609754400
         */
        this.checkOutShiftTime = builder.checkOutShiftTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCheckInRecordId() {
        return this.checkInRecordId;
    }

    public void setCheckInRecordId(String checkInRecordId) {
        this.checkInRecordId = checkInRecordId;
    }

    public UserFlow getCheckInRecord() {
        return this.checkInRecord;
    }

    public void setCheckInRecord(UserFlow checkInRecord) {
        this.checkInRecord = checkInRecord;
    }

    public String getCheckOutRecordId() {
        return this.checkOutRecordId;
    }

    public void setCheckOutRecordId(String checkOutRecordId) {
        this.checkOutRecordId = checkOutRecordId;
    }

    public UserFlow getCheckOutRecord() {
        return this.checkOutRecord;
    }

    public void setCheckOutRecord(UserFlow checkOutRecord) {
        this.checkOutRecord = checkOutRecord;
    }

    public String getCheckInResult() {
        return this.checkInResult;
    }

    public void setCheckInResult(String checkInResult) {
        this.checkInResult = checkInResult;
    }

    public String getCheckOutResult() {
        return this.checkOutResult;
    }

    public void setCheckOutResult(String checkOutResult) {
        this.checkOutResult = checkOutResult;
    }

    public String getCheckInResultSupplement() {
        return this.checkInResultSupplement;
    }

    public void setCheckInResultSupplement(String checkInResultSupplement) {
        this.checkInResultSupplement = checkInResultSupplement;
    }

    public String getCheckOutResultSupplement() {
        return this.checkOutResultSupplement;
    }

    public void setCheckOutResultSupplement(String checkOutResultSupplement) {
        this.checkOutResultSupplement = checkOutResultSupplement;
    }

    public String getCheckInShiftTime() {
        return this.checkInShiftTime;
    }

    public void setCheckInShiftTime(String checkInShiftTime) {
        this.checkInShiftTime = checkInShiftTime;
    }

    public String getCheckOutShiftTime() {
        return this.checkOutShiftTime;
    }

    public void setCheckOutShiftTime(String checkOutShiftTime) {
        this.checkOutShiftTime = checkOutShiftTime;
    }

    public static class Builder {
        /**
         * 上班打卡记录 ID
         * <p> 示例值：6709359313699356941
         */
        private String checkInRecordId;
        /**
         * 上班打卡记录
         * <p> 示例值：
         */
        private UserFlow checkInRecord;
        /**
         * 下班打卡记录 ID
         * <p> 示例值：6709359313699356942
         */
        private String checkOutRecordId;
        /**
         * 下班打卡记录
         * <p> 示例值：
         */
        private UserFlow checkOutRecord;
        /**
         * 上班打卡结果
         * <p> 示例值：SystemCheck
         */
        private String checkInResult;
        /**
         * 下班打卡结果
         * <p> 示例值：SystemCheck
         */
        private String checkOutResult;
        /**
         * 上班打卡结果补充
         * <p> 示例值：None
         */
        private String checkInResultSupplement;
        /**
         * 下班打卡结果补充
         * <p> 示例值：None
         */
        private String checkOutResultSupplement;
        /**
         * 上班打卡时间
         * <p> 示例值：1609722000
         */
        private String checkInShiftTime;
        /**
         * 下班打卡时间
         * <p> 示例值：1609754400
         */
        private String checkOutShiftTime;

        /**
         * 上班打卡记录 ID
         * <p> 示例值：6709359313699356941
         *
         * @param checkInRecordId
         * @return
         */
        public Builder checkInRecordId(String checkInRecordId) {
            this.checkInRecordId = checkInRecordId;
            return this;
        }


        /**
         * 上班打卡记录
         * <p> 示例值：
         *
         * @param checkInRecord
         * @return
         */
        public Builder checkInRecord(UserFlow checkInRecord) {
            this.checkInRecord = checkInRecord;
            return this;
        }


        /**
         * 下班打卡记录 ID
         * <p> 示例值：6709359313699356942
         *
         * @param checkOutRecordId
         * @return
         */
        public Builder checkOutRecordId(String checkOutRecordId) {
            this.checkOutRecordId = checkOutRecordId;
            return this;
        }


        /**
         * 下班打卡记录
         * <p> 示例值：
         *
         * @param checkOutRecord
         * @return
         */
        public Builder checkOutRecord(UserFlow checkOutRecord) {
            this.checkOutRecord = checkOutRecord;
            return this;
        }


        /**
         * 上班打卡结果
         * <p> 示例值：SystemCheck
         *
         * @param checkInResult
         * @return
         */
        public Builder checkInResult(String checkInResult) {
            this.checkInResult = checkInResult;
            return this;
        }

        /**
         * 上班打卡结果
         * <p> 示例值：SystemCheck
         *
         * @param checkInResult {@link com.lark.oapi.service.attendance.v1.enums.TaskResultCheckInResultEnum}
         * @return
         */
        public Builder checkInResult(com.lark.oapi.service.attendance.v1.enums.TaskResultCheckInResultEnum checkInResult) {
            this.checkInResult = checkInResult.getValue();
            return this;
        }


        /**
         * 下班打卡结果
         * <p> 示例值：SystemCheck
         *
         * @param checkOutResult
         * @return
         */
        public Builder checkOutResult(String checkOutResult) {
            this.checkOutResult = checkOutResult;
            return this;
        }

        /**
         * 下班打卡结果
         * <p> 示例值：SystemCheck
         *
         * @param checkOutResult {@link com.lark.oapi.service.attendance.v1.enums.TaskResultCheckOutResultEnum}
         * @return
         */
        public Builder checkOutResult(com.lark.oapi.service.attendance.v1.enums.TaskResultCheckOutResultEnum checkOutResult) {
            this.checkOutResult = checkOutResult.getValue();
            return this;
        }


        /**
         * 上班打卡结果补充
         * <p> 示例值：None
         *
         * @param checkInResultSupplement
         * @return
         */
        public Builder checkInResultSupplement(String checkInResultSupplement) {
            this.checkInResultSupplement = checkInResultSupplement;
            return this;
        }

        /**
         * 上班打卡结果补充
         * <p> 示例值：None
         *
         * @param checkInResultSupplement {@link com.lark.oapi.service.attendance.v1.enums.TaskResultCheckInResultSupplementEnum}
         * @return
         */
        public Builder checkInResultSupplement(com.lark.oapi.service.attendance.v1.enums.TaskResultCheckInResultSupplementEnum checkInResultSupplement) {
            this.checkInResultSupplement = checkInResultSupplement.getValue();
            return this;
        }


        /**
         * 下班打卡结果补充
         * <p> 示例值：None
         *
         * @param checkOutResultSupplement
         * @return
         */
        public Builder checkOutResultSupplement(String checkOutResultSupplement) {
            this.checkOutResultSupplement = checkOutResultSupplement;
            return this;
        }

        /**
         * 下班打卡结果补充
         * <p> 示例值：None
         *
         * @param checkOutResultSupplement {@link com.lark.oapi.service.attendance.v1.enums.TaskResultCheckOutResultSupplementEnum}
         * @return
         */
        public Builder checkOutResultSupplement(com.lark.oapi.service.attendance.v1.enums.TaskResultCheckOutResultSupplementEnum checkOutResultSupplement) {
            this.checkOutResultSupplement = checkOutResultSupplement.getValue();
            return this;
        }


        /**
         * 上班打卡时间
         * <p> 示例值：1609722000
         *
         * @param checkInShiftTime
         * @return
         */
        public Builder checkInShiftTime(String checkInShiftTime) {
            this.checkInShiftTime = checkInShiftTime;
            return this;
        }


        /**
         * 下班打卡时间
         * <p> 示例值：1609754400
         *
         * @param checkOutShiftTime
         * @return
         */
        public Builder checkOutShiftTime(String checkOutShiftTime) {
            this.checkOutShiftTime = checkOutShiftTime;
            return this;
        }


        public TaskResult build() {
            return new TaskResult(this);
        }
    }
}
