// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.contact.v3.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

public class ResurrectUserReq {
    /**
     * 用户id类型
     * <p> 示例值：user_id
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 部门id类型
     * <p> 示例值：department_id
     */
    @Query
    @SerializedName("department_id_type")
    private String departmentIdType;
    /**
     * 用户ID，需要与查询参数中的user_id_type类型保持一致。
     * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad535d62
     */
    @Path
    @SerializedName("user_id")
    private String userId;
    @Body
    private ResurrectUserReqBody body;

    // builder 开始
    public ResurrectUserReq() {
    }

    public ResurrectUserReq(Builder builder) {
        /**
         * 用户id类型
         * <p> 示例值：user_id
         */
        this.userIdType = builder.userIdType;
        /**
         * 部门id类型
         * <p> 示例值：department_id
         */
        this.departmentIdType = builder.departmentIdType;
        /**
         * 用户ID，需要与查询参数中的user_id_type类型保持一致。
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad535d62
         */
        this.userId = builder.userId;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getDepartmentIdType() {
        return this.departmentIdType;
    }

    public void setDepartmentIdType(String departmentIdType) {
        this.departmentIdType = departmentIdType;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ResurrectUserReqBody getResurrectUserReqBody() {
        return this.body;
    }

    public void setResurrectUserReqBody(ResurrectUserReqBody body) {
        this.body = body;
    }

    public static class Builder {
        private String userIdType; // 用户id类型
        private String departmentIdType; // 部门id类型
        private String userId; // 用户ID，需要与查询参数中的user_id_type类型保持一致。
        private ResurrectUserReqBody body;

        /**
         * 用户id类型
         * <p> 示例值：user_id
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 用户id类型
         * <p> 示例值：user_id
         *
         * @param userIdType {@link com.lark.oapi.service.contact.v3.enums.ResurrectUserUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.contact.v3.enums.ResurrectUserUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        /**
         * 部门id类型
         * <p> 示例值：department_id
         *
         * @param departmentIdType
         * @return
         */
        public Builder departmentIdType(String departmentIdType) {
            this.departmentIdType = departmentIdType;
            return this;
        }

        /**
         * 部门id类型
         * <p> 示例值：department_id
         *
         * @param departmentIdType {@link com.lark.oapi.service.contact.v3.enums.ResurrectUserDepartmentIdTypeEnum}
         * @return
         */
        public Builder departmentIdType(com.lark.oapi.service.contact.v3.enums.ResurrectUserDepartmentIdTypeEnum departmentIdType) {
            this.departmentIdType = departmentIdType.getValue();
            return this;
        }

        /**
         * 用户ID，需要与查询参数中的user_id_type类型保持一致。
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad535d62
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public ResurrectUserReqBody getResurrectUserReqBody() {
            return this.body;
        }

        /**
         * body
         *
         * @param body
         * @return
         */
        public Builder resurrectUserReqBody(ResurrectUserReqBody body) {
            this.body = body;
            return this;
        }

        public ResurrectUserReq build() {
            return new ResurrectUserReq(this);
        }
    }
}
