// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Query;

public class LeaveRequestHistoryLeaveReq {
    /**
     * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
     * <p> 示例值：eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9
     */
    @Query
    @SerializedName("page_token")
    private String pageToken;
    /**
     * 每页获取记录数量，最大100
     * <p> 示例值：100
     */
    @Query
    @SerializedName("page_size")
    private String pageSize;
    /**
     * 员工 ID 列表，最大 100 个（不传则默认查询全部员工）
     * <p> 示例值：["6919733291281024526"]
     */
    @Query
    @SerializedName("employment_id_list")
    private String[] employmentIdList;
    /**
     * 休假发起人 ID 列表，最大 100 个
     * <p> 示例值：["6919733291281024526"]
     */
    @Query
    @SerializedName("initiator_id_list")
    private String[] initiatorIdList;
    /**
     * 请假记录的状态;;可选值有：;;- 1：已通过;;- 2：审批中;;- 3：审批中（更正）;;- 4：审批中（取消休假）;;- 5：审批中（返岗）;;- 6：已返岗;;- 7：已拒绝;;- 8：已取消;;- 9：已撤回
     * <p> 示例值：["1", "2"]
     */
    @Query
    @SerializedName("leave_request_status")
    private String[] leaveRequestStatus;
    /**
     * 假期类型 ID 列表，枚举值可通过【获取假期类型列表】接口获取
     * <p> 示例值：["1"]
     */
    @Query
    @SerializedName("leave_type_id_list")
    private String[] leaveTypeIdList;
    /**
     * 休假开始时间晚于等于的日期
     * <p> 示例值：2022-07-20 morning
     */
    @Query
    @SerializedName("leave_start_date_min")
    private String leaveStartDateMin;
    /**
     * 休假开始时间早于等于的日期
     * <p> 示例值：2022-07-20 morning
     */
    @Query
    @SerializedName("leave_start_date_max")
    private String leaveStartDateMax;
    /**
     * 休假结束时间晚于等于的日期
     * <p> 示例值：2022-07-20 morning
     */
    @Query
    @SerializedName("leave_end_date_min")
    private String leaveEndDateMin;
    /**
     * 休假结束时间早于等于的日期
     * <p> 示例值：2022-07-20 morning
     */
    @Query
    @SerializedName("leave_end_date_max")
    private String leaveEndDateMax;
    /**
     * 休假发起时间晚于等于的日期
     * <p> 示例值：2022-07-20 morning
     */
    @Query
    @SerializedName("leave_submit_date_min")
    private String leaveSubmitDateMin;
    /**
     * 休假发起时间早于等于的日期
     * <p> 示例值：2022-07-20 morning
     */
    @Query
    @SerializedName("leave_submit_date_max")
    private String leaveSubmitDateMax;
    /**
     * 用户 ID 类型
     * <p> 示例值：people_corehr_id
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 请假记录更新时间晚于等于的时间
     * <p> 示例值：2022-10-24 10:00:00
     */
    @Query
    @SerializedName("leave_update_time_min")
    private String leaveUpdateTimeMin;
    /**
     * 请假记录更新时间早于等于的时间
     * <p> 示例值：2022-10-24 10:00:00
     */
    @Query
    @SerializedName("leave_update_time_max")
    private String leaveUpdateTimeMax;

    // builder 开始
    public LeaveRequestHistoryLeaveReq() {
    }

    public LeaveRequestHistoryLeaveReq(Builder builder) {
        /**
         * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
         * <p> 示例值：eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9
         */
        this.pageToken = builder.pageToken;
        /**
         * 每页获取记录数量，最大100
         * <p> 示例值：100
         */
        this.pageSize = builder.pageSize;
        /**
         * 员工 ID 列表，最大 100 个（不传则默认查询全部员工）
         * <p> 示例值：["6919733291281024526"]
         */
        this.employmentIdList = builder.employmentIdList;
        /**
         * 休假发起人 ID 列表，最大 100 个
         * <p> 示例值：["6919733291281024526"]
         */
        this.initiatorIdList = builder.initiatorIdList;
        /**
         * 请假记录的状态;;可选值有：;;- 1：已通过;;- 2：审批中;;- 3：审批中（更正）;;- 4：审批中（取消休假）;;- 5：审批中（返岗）;;- 6：已返岗;;- 7：已拒绝;;- 8：已取消;;- 9：已撤回
         * <p> 示例值：["1", "2"]
         */
        this.leaveRequestStatus = builder.leaveRequestStatus;
        /**
         * 假期类型 ID 列表，枚举值可通过【获取假期类型列表】接口获取
         * <p> 示例值：["1"]
         */
        this.leaveTypeIdList = builder.leaveTypeIdList;
        /**
         * 休假开始时间晚于等于的日期
         * <p> 示例值：2022-07-20 morning
         */
        this.leaveStartDateMin = builder.leaveStartDateMin;
        /**
         * 休假开始时间早于等于的日期
         * <p> 示例值：2022-07-20 morning
         */
        this.leaveStartDateMax = builder.leaveStartDateMax;
        /**
         * 休假结束时间晚于等于的日期
         * <p> 示例值：2022-07-20 morning
         */
        this.leaveEndDateMin = builder.leaveEndDateMin;
        /**
         * 休假结束时间早于等于的日期
         * <p> 示例值：2022-07-20 morning
         */
        this.leaveEndDateMax = builder.leaveEndDateMax;
        /**
         * 休假发起时间晚于等于的日期
         * <p> 示例值：2022-07-20 morning
         */
        this.leaveSubmitDateMin = builder.leaveSubmitDateMin;
        /**
         * 休假发起时间早于等于的日期
         * <p> 示例值：2022-07-20 morning
         */
        this.leaveSubmitDateMax = builder.leaveSubmitDateMax;
        /**
         * 用户 ID 类型
         * <p> 示例值：people_corehr_id
         */
        this.userIdType = builder.userIdType;
        /**
         * 请假记录更新时间晚于等于的时间
         * <p> 示例值：2022-10-24 10:00:00
         */
        this.leaveUpdateTimeMin = builder.leaveUpdateTimeMin;
        /**
         * 请假记录更新时间早于等于的时间
         * <p> 示例值：2022-10-24 10:00:00
         */
        this.leaveUpdateTimeMax = builder.leaveUpdateTimeMax;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public String[] getEmploymentIdList() {
        return this.employmentIdList;
    }

    public void setEmploymentIdList(String[] employmentIdList) {
        this.employmentIdList = employmentIdList;
    }

    public String[] getInitiatorIdList() {
        return this.initiatorIdList;
    }

    public void setInitiatorIdList(String[] initiatorIdList) {
        this.initiatorIdList = initiatorIdList;
    }

    public String[] getLeaveRequestStatus() {
        return this.leaveRequestStatus;
    }

    public void setLeaveRequestStatus(String[] leaveRequestStatus) {
        this.leaveRequestStatus = leaveRequestStatus;
    }

    public String[] getLeaveTypeIdList() {
        return this.leaveTypeIdList;
    }

    public void setLeaveTypeIdList(String[] leaveTypeIdList) {
        this.leaveTypeIdList = leaveTypeIdList;
    }

    public String getLeaveStartDateMin() {
        return this.leaveStartDateMin;
    }

    public void setLeaveStartDateMin(String leaveStartDateMin) {
        this.leaveStartDateMin = leaveStartDateMin;
    }

    public String getLeaveStartDateMax() {
        return this.leaveStartDateMax;
    }

    public void setLeaveStartDateMax(String leaveStartDateMax) {
        this.leaveStartDateMax = leaveStartDateMax;
    }

    public String getLeaveEndDateMin() {
        return this.leaveEndDateMin;
    }

    public void setLeaveEndDateMin(String leaveEndDateMin) {
        this.leaveEndDateMin = leaveEndDateMin;
    }

    public String getLeaveEndDateMax() {
        return this.leaveEndDateMax;
    }

    public void setLeaveEndDateMax(String leaveEndDateMax) {
        this.leaveEndDateMax = leaveEndDateMax;
    }

    public String getLeaveSubmitDateMin() {
        return this.leaveSubmitDateMin;
    }

    public void setLeaveSubmitDateMin(String leaveSubmitDateMin) {
        this.leaveSubmitDateMin = leaveSubmitDateMin;
    }

    public String getLeaveSubmitDateMax() {
        return this.leaveSubmitDateMax;
    }

    public void setLeaveSubmitDateMax(String leaveSubmitDateMax) {
        this.leaveSubmitDateMax = leaveSubmitDateMax;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getLeaveUpdateTimeMin() {
        return this.leaveUpdateTimeMin;
    }

    public void setLeaveUpdateTimeMin(String leaveUpdateTimeMin) {
        this.leaveUpdateTimeMin = leaveUpdateTimeMin;
    }

    public String getLeaveUpdateTimeMax() {
        return this.leaveUpdateTimeMax;
    }

    public void setLeaveUpdateTimeMax(String leaveUpdateTimeMax) {
        this.leaveUpdateTimeMax = leaveUpdateTimeMax;
    }

    public static class Builder {
        private String pageToken; // 页码标识，获取第一页传空，每次查询会返回下一页的page_token
        private String pageSize; // 每页获取记录数量，最大100
        private String[] employmentIdList; // 员工 ID 列表，最大 100 个（不传则默认查询全部员工）
        private String[] initiatorIdList; // 休假发起人 ID 列表，最大 100 个
        private String[] leaveRequestStatus; // 请假记录的状态;;可选值有：;;- 1：已通过;;- 2：审批中;;- 3：审批中（更正）;;- 4：审批中（取消休假）;;- 5：审批中（返岗）;;- 6：已返岗;;- 7：已拒绝;;- 8：已取消;;- 9：已撤回
        private String[] leaveTypeIdList; // 假期类型 ID 列表，枚举值可通过【获取假期类型列表】接口获取
        private String leaveStartDateMin; // 休假开始时间晚于等于的日期
        private String leaveStartDateMax; // 休假开始时间早于等于的日期
        private String leaveEndDateMin; // 休假结束时间晚于等于的日期
        private String leaveEndDateMax; // 休假结束时间早于等于的日期
        private String leaveSubmitDateMin; // 休假发起时间晚于等于的日期
        private String leaveSubmitDateMax; // 休假发起时间早于等于的日期
        private String userIdType; // 用户 ID 类型
        private String leaveUpdateTimeMin; // 请假记录更新时间晚于等于的时间
        private String leaveUpdateTimeMax; // 请假记录更新时间早于等于的时间


        /**
         * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
         * <p> 示例值：eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        /**
         * 每页获取记录数量，最大100
         * <p> 示例值：100
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 员工 ID 列表，最大 100 个（不传则默认查询全部员工）
         * <p> 示例值：["6919733291281024526"]
         *
         * @param employmentIdList
         * @return
         */
        public Builder employmentIdList(String[] employmentIdList) {
            this.employmentIdList = employmentIdList;
            return this;
        }


        /**
         * 休假发起人 ID 列表，最大 100 个
         * <p> 示例值：["6919733291281024526"]
         *
         * @param initiatorIdList
         * @return
         */
        public Builder initiatorIdList(String[] initiatorIdList) {
            this.initiatorIdList = initiatorIdList;
            return this;
        }


        /**
         * 请假记录的状态;;可选值有：;;- 1：已通过;;- 2：审批中;;- 3：审批中（更正）;;- 4：审批中（取消休假）;;- 5：审批中（返岗）;;- 6：已返岗;;- 7：已拒绝;;- 8：已取消;;- 9：已撤回
         * <p> 示例值：["1", "2"]
         *
         * @param leaveRequestStatus
         * @return
         */
        public Builder leaveRequestStatus(String[] leaveRequestStatus) {
            this.leaveRequestStatus = leaveRequestStatus;
            return this;
        }


        /**
         * 假期类型 ID 列表，枚举值可通过【获取假期类型列表】接口获取
         * <p> 示例值：["1"]
         *
         * @param leaveTypeIdList
         * @return
         */
        public Builder leaveTypeIdList(String[] leaveTypeIdList) {
            this.leaveTypeIdList = leaveTypeIdList;
            return this;
        }


        /**
         * 休假开始时间晚于等于的日期
         * <p> 示例值：2022-07-20 morning
         *
         * @param leaveStartDateMin
         * @return
         */
        public Builder leaveStartDateMin(String leaveStartDateMin) {
            this.leaveStartDateMin = leaveStartDateMin;
            return this;
        }


        /**
         * 休假开始时间早于等于的日期
         * <p> 示例值：2022-07-20 morning
         *
         * @param leaveStartDateMax
         * @return
         */
        public Builder leaveStartDateMax(String leaveStartDateMax) {
            this.leaveStartDateMax = leaveStartDateMax;
            return this;
        }


        /**
         * 休假结束时间晚于等于的日期
         * <p> 示例值：2022-07-20 morning
         *
         * @param leaveEndDateMin
         * @return
         */
        public Builder leaveEndDateMin(String leaveEndDateMin) {
            this.leaveEndDateMin = leaveEndDateMin;
            return this;
        }


        /**
         * 休假结束时间早于等于的日期
         * <p> 示例值：2022-07-20 morning
         *
         * @param leaveEndDateMax
         * @return
         */
        public Builder leaveEndDateMax(String leaveEndDateMax) {
            this.leaveEndDateMax = leaveEndDateMax;
            return this;
        }


        /**
         * 休假发起时间晚于等于的日期
         * <p> 示例值：2022-07-20 morning
         *
         * @param leaveSubmitDateMin
         * @return
         */
        public Builder leaveSubmitDateMin(String leaveSubmitDateMin) {
            this.leaveSubmitDateMin = leaveSubmitDateMin;
            return this;
        }


        /**
         * 休假发起时间早于等于的日期
         * <p> 示例值：2022-07-20 morning
         *
         * @param leaveSubmitDateMax
         * @return
         */
        public Builder leaveSubmitDateMax(String leaveSubmitDateMax) {
            this.leaveSubmitDateMax = leaveSubmitDateMax;
            return this;
        }


        /**
         * 用户 ID 类型
         * <p> 示例值：people_corehr_id
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 用户 ID 类型
         * <p> 示例值：people_corehr_id
         *
         * @param userIdType {@link com.lark.oapi.service.corehr.v1.enums.LeaveRequestHistoryLeaveUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.corehr.v1.enums.LeaveRequestHistoryLeaveUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }


        /**
         * 请假记录更新时间晚于等于的时间
         * <p> 示例值：2022-10-24 10:00:00
         *
         * @param leaveUpdateTimeMin
         * @return
         */
        public Builder leaveUpdateTimeMin(String leaveUpdateTimeMin) {
            this.leaveUpdateTimeMin = leaveUpdateTimeMin;
            return this;
        }


        /**
         * 请假记录更新时间早于等于的时间
         * <p> 示例值：2022-10-24 10:00:00
         *
         * @param leaveUpdateTimeMax
         * @return
         */
        public Builder leaveUpdateTimeMax(String leaveUpdateTimeMax) {
            this.leaveUpdateTimeMax = leaveUpdateTimeMax;
            return this;
        }

        public LeaveRequestHistoryLeaveReq build() {
            return new LeaveRequestHistoryLeaveReq(this);
        }
    }
}
