// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.drive.v1.model;

import com.google.gson.annotations.SerializedName;

public class Collaborator {
    /**
     * 协作者类型 "user" or "chat"
     * <p> 示例值：user
     */
    @SerializedName("member_type")
    private String memberType;
    /**
     * 协作者openid
     * <p> 示例值：ou_65b0affcc6c342a50e4c66f700137b64
     */
    @SerializedName("member_open_id")
    private String memberOpenId;
    /**
     * 协作者userid(仅当member_type="user"时有效)
     * <p> 示例值：96g3c421
     */
    @SerializedName("member_user_id")
    private String memberUserId;
    /**
     * 协作者权限 (注意: **有"edit"权限的协作者一定有"view"权限**)
     * <p> 示例值：view
     */
    @SerializedName("perm")
    private String perm;

    // builder 开始
    public Collaborator() {
    }

    public Collaborator(Builder builder) {
        /**
         * 协作者类型 "user" or "chat"
         * <p> 示例值：user
         */
        this.memberType = builder.memberType;
        /**
         * 协作者openid
         * <p> 示例值：ou_65b0affcc6c342a50e4c66f700137b64
         */
        this.memberOpenId = builder.memberOpenId;
        /**
         * 协作者userid(仅当member_type="user"时有效)
         * <p> 示例值：96g3c421
         */
        this.memberUserId = builder.memberUserId;
        /**
         * 协作者权限 (注意: **有"edit"权限的协作者一定有"view"权限**)
         * <p> 示例值：view
         */
        this.perm = builder.perm;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getMemberType() {
        return this.memberType;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public String getMemberOpenId() {
        return this.memberOpenId;
    }

    public void setMemberOpenId(String memberOpenId) {
        this.memberOpenId = memberOpenId;
    }

    public String getMemberUserId() {
        return this.memberUserId;
    }

    public void setMemberUserId(String memberUserId) {
        this.memberUserId = memberUserId;
    }

    public String getPerm() {
        return this.perm;
    }

    public void setPerm(String perm) {
        this.perm = perm;
    }

    public static class Builder {
        /**
         * 协作者类型 "user" or "chat"
         * <p> 示例值：user
         */
        private String memberType;
        /**
         * 协作者openid
         * <p> 示例值：ou_65b0affcc6c342a50e4c66f700137b64
         */
        private String memberOpenId;
        /**
         * 协作者userid(仅当member_type="user"时有效)
         * <p> 示例值：96g3c421
         */
        private String memberUserId;
        /**
         * 协作者权限 (注意: **有"edit"权限的协作者一定有"view"权限**)
         * <p> 示例值：view
         */
        private String perm;

        /**
         * 协作者类型 "user" or "chat"
         * <p> 示例值：user
         *
         * @param memberType
         * @return
         */
        public Builder memberType(String memberType) {
            this.memberType = memberType;
            return this;
        }


        /**
         * 协作者openid
         * <p> 示例值：ou_65b0affcc6c342a50e4c66f700137b64
         *
         * @param memberOpenId
         * @return
         */
        public Builder memberOpenId(String memberOpenId) {
            this.memberOpenId = memberOpenId;
            return this;
        }


        /**
         * 协作者userid(仅当member_type="user"时有效)
         * <p> 示例值：96g3c421
         *
         * @param memberUserId
         * @return
         */
        public Builder memberUserId(String memberUserId) {
            this.memberUserId = memberUserId;
            return this;
        }


        /**
         * 协作者权限 (注意: **有"edit"权限的协作者一定有"view"权限**)
         * <p> 示例值：view
         *
         * @param perm
         * @return
         */
        public Builder perm(String perm) {
            this.perm = perm;
            return this;
        }


        public Collaborator build() {
            return new Collaborator(this);
        }
    }
}
