// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.im.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Query;

public class ListMessageReq {
    /**
     * 容器类型 ，目前可选值仅有"chat"，包含单聊（p2p）和群聊（group）
     * <p> 示例值：chat
     */
    @Query
    @SerializedName("container_id_type")
    private String containerIdType;
    /**
     * 容器的id，即chat的id，详情参见[群ID 说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description)
     * <p> 示例值：oc_234jsi43d3ssi993d43545f
     */
    @Query
    @SerializedName("container_id")
    private String containerId;
    /**
     * 历史信息的起始时间（秒级时间戳）
     * <p> 示例值：1609296809
     */
    @Query
    @SerializedName("start_time")
    private String startTime;
    /**
     * 历史信息的结束时间（秒级时间戳）
     * <p> 示例值：1608594809
     */
    @Query
    @SerializedName("end_time")
    private String endTime;
    /**
     * 分页大小
     * <p> 示例值：20
     */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
    /**
     * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
     * <p> 示例值：GxmvlNRvP0NdQZpa7yIqf_Lv_QuBwTQ8tXkX7w-irAghVD_TvuYd1aoJ1LQph86O-XImC4X9j9FhUPhXQDvtrQ==
     */
    @Query
    @SerializedName("page_token")
    private String pageToken;

    // builder 开始
    public ListMessageReq() {
    }

    public ListMessageReq(Builder builder) {
        /**
         * 容器类型 ，目前可选值仅有"chat"，包含单聊（p2p）和群聊（group）
         * <p> 示例值：chat
         */
        this.containerIdType = builder.containerIdType;
        /**
         * 容器的id，即chat的id，详情参见[群ID 说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description)
         * <p> 示例值：oc_234jsi43d3ssi993d43545f
         */
        this.containerId = builder.containerId;
        /**
         * 历史信息的起始时间（秒级时间戳）
         * <p> 示例值：1609296809
         */
        this.startTime = builder.startTime;
        /**
         * 历史信息的结束时间（秒级时间戳）
         * <p> 示例值：1608594809
         */
        this.endTime = builder.endTime;
        /**
         * 分页大小
         * <p> 示例值：20
         */
        this.pageSize = builder.pageSize;
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
         * <p> 示例值：GxmvlNRvP0NdQZpa7yIqf_Lv_QuBwTQ8tXkX7w-irAghVD_TvuYd1aoJ1LQph86O-XImC4X9j9FhUPhXQDvtrQ==
         */
        this.pageToken = builder.pageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getContainerIdType() {
        return this.containerIdType;
    }

    public void setContainerIdType(String containerIdType) {
        this.containerIdType = containerIdType;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public static class Builder {
        private String containerIdType; // 容器类型 ，目前可选值仅有"chat"，包含单聊（p2p）和群聊（group）
        private String containerId; // 容器的id，即chat的id，详情参见[群ID 说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description)
        private String startTime; // 历史信息的起始时间（秒级时间戳）
        private String endTime; // 历史信息的结束时间（秒级时间戳）
        private Integer pageSize; // 分页大小
        private String pageToken; // 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果


        /**
         * 容器类型 ，目前可选值仅有"chat"，包含单聊（p2p）和群聊（group）
         * <p> 示例值：chat
         *
         * @param containerIdType
         * @return
         */
        public Builder containerIdType(String containerIdType) {
            this.containerIdType = containerIdType;
            return this;
        }


        /**
         * 容器的id，即chat的id，详情参见[群ID 说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description)
         * <p> 示例值：oc_234jsi43d3ssi993d43545f
         *
         * @param containerId
         * @return
         */
        public Builder containerId(String containerId) {
            this.containerId = containerId;
            return this;
        }


        /**
         * 历史信息的起始时间（秒级时间戳）
         * <p> 示例值：1609296809
         *
         * @param startTime
         * @return
         */
        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }


        /**
         * 历史信息的结束时间（秒级时间戳）
         * <p> 示例值：1608594809
         *
         * @param endTime
         * @return
         */
        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }


        /**
         * 分页大小
         * <p> 示例值：20
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
         * <p> 示例值：GxmvlNRvP0NdQZpa7yIqf_Lv_QuBwTQ8tXkX7w-irAghVD_TvuYd1aoJ1LQph86O-XImC4X9j9FhUPhXQDvtrQ==
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public ListMessageReq build() {
            return new ListMessageReq(this);
        }
    }
}
