// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Query;

public class ReserveScopeReserveConfigReq {
    /**
     * 会议室或层级id
     * <p> 示例值：omm_3c5dd7e09bac0c1758fcf9511bd1a771
     */
    @Query
    @SerializedName("scope_id")
    private String scopeId;
    /**
     * 1 代表层级，2 代表会议室
     * <p> 示例值：2
     */
    @Query
    @SerializedName("scope_type")
    private String scopeType;
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;

    // builder 开始
    public ReserveScopeReserveConfigReq() {
    }

    public ReserveScopeReserveConfigReq(Builder builder) {
        /**
         * 会议室或层级id
         * <p> 示例值：omm_3c5dd7e09bac0c1758fcf9511bd1a771
         */
        this.scopeId = builder.scopeId;
        /**
         * 1 代表层级，2 代表会议室
         * <p> 示例值：2
         */
        this.scopeType = builder.scopeType;
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         */
        this.userIdType = builder.userIdType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public static class Builder {
        private String scopeId; // 会议室或层级id
        private String scopeType; // 1 代表层级，2 代表会议室
        private String userIdType; // 此次调用中使用的用户ID的类型


        /**
         * 会议室或层级id
         * <p> 示例值：omm_3c5dd7e09bac0c1758fcf9511bd1a771
         *
         * @param scopeId
         * @return
         */
        public Builder scopeId(String scopeId) {
            this.scopeId = scopeId;
            return this;
        }


        /**
         * 1 代表层级，2 代表会议室
         * <p> 示例值：2
         *
         * @param scopeType
         * @return
         */
        public Builder scopeType(String scopeType) {
            this.scopeType = scopeType;
            return this;
        }


        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType {@link com.lark.oapi.service.vc.v1.enums.ReserveScopeReserveConfigUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.vc.v1.enums.ReserveScopeReserveConfigUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        public ReserveScopeReserveConfigReq build() {
            return new ReserveScopeReserveConfigReq(this);
        }
    }
}
