// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1.model;

import com.google.gson.annotations.SerializedName;

public class RoomConfig {
    /**
     * 飞书会议室背景图
     * <p> 示例值：https://lf1-ttcdn-tos.pstatp.com/obj/xxx
     */
    @SerializedName("room_background")
    private String roomBackground;
    /**
     * 飞书签到板背景图
     * <p> 示例值：https://lf1-ttcdn-tos.pstatp.com/obj/xxx
     */
    @SerializedName("display_background")
    private String displayBackground;
    /**
     * 飞书会议室数字标牌
     * <p> 示例值：
     */
    @SerializedName("digital_signage")
    private RoomDigitalSignage digitalSignage;
    /**
     * 飞书投屏盒子数字标牌
     * <p> 示例值：
     */
    @SerializedName("room_box_digital_signage")
    private RoomDigitalSignage roomBoxDigitalSignage;
    /**
     * 会议室状态
     * <p> 示例值：
     */
    @SerializedName("room_status")
    private RoomStatus roomStatus;

    // builder 开始
    public RoomConfig() {
    }

    public RoomConfig(Builder builder) {
        /**
         * 飞书会议室背景图
         * <p> 示例值：https://lf1-ttcdn-tos.pstatp.com/obj/xxx
         */
        this.roomBackground = builder.roomBackground;
        /**
         * 飞书签到板背景图
         * <p> 示例值：https://lf1-ttcdn-tos.pstatp.com/obj/xxx
         */
        this.displayBackground = builder.displayBackground;
        /**
         * 飞书会议室数字标牌
         * <p> 示例值：
         */
        this.digitalSignage = builder.digitalSignage;
        /**
         * 飞书投屏盒子数字标牌
         * <p> 示例值：
         */
        this.roomBoxDigitalSignage = builder.roomBoxDigitalSignage;
        /**
         * 会议室状态
         * <p> 示例值：
         */
        this.roomStatus = builder.roomStatus;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRoomBackground() {
        return this.roomBackground;
    }

    public void setRoomBackground(String roomBackground) {
        this.roomBackground = roomBackground;
    }

    public String getDisplayBackground() {
        return this.displayBackground;
    }

    public void setDisplayBackground(String displayBackground) {
        this.displayBackground = displayBackground;
    }

    public RoomDigitalSignage getDigitalSignage() {
        return this.digitalSignage;
    }

    public void setDigitalSignage(RoomDigitalSignage digitalSignage) {
        this.digitalSignage = digitalSignage;
    }

    public RoomDigitalSignage getRoomBoxDigitalSignage() {
        return this.roomBoxDigitalSignage;
    }

    public void setRoomBoxDigitalSignage(RoomDigitalSignage roomBoxDigitalSignage) {
        this.roomBoxDigitalSignage = roomBoxDigitalSignage;
    }

    public RoomStatus getRoomStatus() {
        return this.roomStatus;
    }

    public void setRoomStatus(RoomStatus roomStatus) {
        this.roomStatus = roomStatus;
    }

    public static class Builder {
        /**
         * 飞书会议室背景图
         * <p> 示例值：https://lf1-ttcdn-tos.pstatp.com/obj/xxx
         */
        private String roomBackground;
        /**
         * 飞书签到板背景图
         * <p> 示例值：https://lf1-ttcdn-tos.pstatp.com/obj/xxx
         */
        private String displayBackground;
        /**
         * 飞书会议室数字标牌
         * <p> 示例值：
         */
        private RoomDigitalSignage digitalSignage;
        /**
         * 飞书投屏盒子数字标牌
         * <p> 示例值：
         */
        private RoomDigitalSignage roomBoxDigitalSignage;
        /**
         * 会议室状态
         * <p> 示例值：
         */
        private RoomStatus roomStatus;

        /**
         * 飞书会议室背景图
         * <p> 示例值：https://lf1-ttcdn-tos.pstatp.com/obj/xxx
         *
         * @param roomBackground
         * @return
         */
        public Builder roomBackground(String roomBackground) {
            this.roomBackground = roomBackground;
            return this;
        }


        /**
         * 飞书签到板背景图
         * <p> 示例值：https://lf1-ttcdn-tos.pstatp.com/obj/xxx
         *
         * @param displayBackground
         * @return
         */
        public Builder displayBackground(String displayBackground) {
            this.displayBackground = displayBackground;
            return this;
        }


        /**
         * 飞书会议室数字标牌
         * <p> 示例值：
         *
         * @param digitalSignage
         * @return
         */
        public Builder digitalSignage(RoomDigitalSignage digitalSignage) {
            this.digitalSignage = digitalSignage;
            return this;
        }


        /**
         * 飞书投屏盒子数字标牌
         * <p> 示例值：
         *
         * @param roomBoxDigitalSignage
         * @return
         */
        public Builder roomBoxDigitalSignage(RoomDigitalSignage roomBoxDigitalSignage) {
            this.roomBoxDigitalSignage = roomBoxDigitalSignage;
            return this;
        }


        /**
         * 会议室状态
         * <p> 示例值：
         *
         * @param roomStatus
         * @return
         */
        public Builder roomStatus(RoomStatus roomStatus) {
            this.roomStatus = roomStatus;
            return this;
        }


        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}
