/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.core;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.exception.AccessTokenNotGivenException;
import com.lark.oapi.core.exception.ClientTimeoutException;
import com.lark.oapi.core.exception.IllegalAccessTokenTypeException;
import com.lark.oapi.core.exception.ServerTimeoutException;
import com.lark.oapi.core.httpclient.IHttpTransport;
import com.lark.oapi.core.httpclient.OkHttpTransport;
import com.lark.oapi.core.request.RawRequest;
import com.lark.oapi.core.request.ReqTranslator;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.OKHttps;
import com.lark.oapi.core.utils.Strings;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transport {
    private static final Logger log = LoggerFactory.getLogger(Transport.class);
    private static final ReqTranslator REQ_TRANSLATOR = new ReqTranslator();

    private static AccessTokenType determineTokenType(Set<AccessTokenType> accessTokenTypeSet, RequestOptions requestOptions, boolean disableTokenCache) {
        if (accessTokenTypeSet.contains((Object)AccessTokenType.None)) {
            return AccessTokenType.None;
        }
        Transport.validateTokenType(accessTokenTypeSet, requestOptions);
        if (disableTokenCache) {
            if (Strings.isNotEmpty(requestOptions.getUserAccessToken())) {
                return AccessTokenType.User;
            }
            if (Strings.isNotEmpty(requestOptions.getTenantAccessToken())) {
                return AccessTokenType.Tenant;
            }
            if (Strings.isNotEmpty(requestOptions.getAppAccessToken())) {
                return AccessTokenType.App;
            }
            throw new AccessTokenNotGivenException();
        }
        if (Strings.isNotEmpty(requestOptions.getTenantKey()) && accessTokenTypeSet.contains((Object)AccessTokenType.Tenant)) {
            return AccessTokenType.Tenant;
        }
        if (Strings.isNotEmpty(requestOptions.getUserAccessToken()) && accessTokenTypeSet.contains((Object)AccessTokenType.User)) {
            return AccessTokenType.User;
        }
        if (accessTokenTypeSet.contains((Object)AccessTokenType.Tenant)) {
            return AccessTokenType.Tenant;
        }
        if (accessTokenTypeSet.contains((Object)AccessTokenType.App)) {
            return AccessTokenType.App;
        }
        throw new IllegalAccessTokenTypeException();
    }

    public static void validateTokenType(Set<AccessTokenType> accessTokenTypeSet, RequestOptions requestOptions) {
        if (requestOptions == null || accessTokenTypeSet == null || accessTokenTypeSet.size() == 0 || accessTokenTypeSet.size() > 1) {
            return;
        }
        AccessTokenType accessTokenType = accessTokenTypeSet.iterator().next();
        if (accessTokenType == AccessTokenType.Tenant && Strings.isNotEmpty(requestOptions.getUserAccessToken())) {
            throw new IllegalArgumentException("tenant token type not match user access token");
        }
        if (accessTokenType == AccessTokenType.User && Strings.isNotEmpty(requestOptions.getTenantAccessToken())) {
            throw new IllegalArgumentException("user token type not match tenant access token");
        }
    }

    private static void validate(Config config, RequestOptions requestOptions, AccessTokenType accessTokenType) {
        if (Strings.isEmpty(config.getAppId())) {
            throw new IllegalArgumentException("appId is blank");
        }
        if (Strings.isEmpty(config.getAppSecret())) {
            throw new IllegalArgumentException("appSecret is blank");
        }
        if (config.isDisableTokenCache()) {
            if (accessTokenType == AccessTokenType.None) {
                return;
            }
            if (Strings.isEmpty(requestOptions.getUserAccessToken()) && Strings.isEmpty(requestOptions.getTenantAccessToken()) && Strings.isEmpty(requestOptions.getAppAccessToken())) {
                throw new IllegalArgumentException("access token is blank");
            }
        }
        if (accessTokenType == AccessTokenType.Tenant && Strings.isNotEmpty(requestOptions.getUserAccessToken())) {
            throw new IllegalArgumentException("tenant token type not match user access token");
        }
        if (accessTokenType == AccessTokenType.User && Strings.isNotEmpty(requestOptions.getTenantAccessToken())) {
            throw new IllegalArgumentException("user token type not match tenant access token");
        }
        if (accessTokenType == AccessTokenType.User && Strings.isEmpty(requestOptions.getUserAccessToken())) {
            throw new IllegalArgumentException("user access token is blank");
        }
        if (requestOptions.getHeaders() != null && requestOptions.getHeaders().size() > 0) {
            requestOptions.getHeaders().entrySet().stream().forEach(entry -> {
                if (((String)entry.getKey()).equalsIgnoreCase("X-Request-Id")) {
                    throw new IllegalArgumentException(String.format("pass %s as header key is not allowed", entry.getKey()));
                }
                if (((String)entry.getKey()).equalsIgnoreCase("X-Tt-Logid")) {
                    throw new IllegalArgumentException(String.format("pass %s as header key is not allowed", entry.getKey()));
                }
                if (((String)entry.getKey()).equalsIgnoreCase("Request-Id")) {
                    throw new IllegalArgumentException(String.format("pass %s as header key is not allowed", entry.getKey()));
                }
            });
        }
    }

    public static RawResponse send(Config config, RequestOptions requestOptions, String methodType, String path, Set<AccessTokenType> accessTokenTypeSet, Object req) throws Exception {
        try {
            if (requestOptions == null) {
                requestOptions = new RequestOptions();
            }
            if (accessTokenTypeSet.isEmpty()) {
                accessTokenTypeSet.add(AccessTokenType.None);
            }
            AccessTokenType accessTokenType = Transport.determineTokenType(accessTokenTypeSet, requestOptions, config.isDisableTokenCache());
            Transport.validate(config, requestOptions, accessTokenType);
            return Transport.doSend(config, methodType, path, accessTokenType, req, requestOptions);
        }
        catch (InterruptedIOException e) {
            log.error("send error:{},{}", new Object[]{methodType, path, e});
            if ("timeout".equals(e.getMessage())) {
                throw new ClientTimeoutException();
            }
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
    }

    private static void logReq(RawRequest req, String httpPath, boolean isUpload) {
        try {
            if (null == req) {
                return;
            }
            if (!isUpload) {
                log.debug("req,path:{},header:{},body:{}", new Object[]{httpPath, Jsons.DEFAULT.toJson(req.getHeaders()), req.getBody() == null ? "" : Jsons.DEFAULT.toJson(req.getBody())});
            } else {
                log.debug("req,path:{},header:{}", (Object)httpPath, req.getHeaders());
            }
        }
        catch (Throwable e) {
            log.error("logReq error:{}", e);
        }
    }

    private static RawResponse doSend(Config config, String httpMethod, String httpPath, AccessTokenType accessTokenType, Object req, RequestOptions requestOptions) throws Exception {
        Exception error = null;
        for (int i = 0; i < 2; ++i) {
            try {
                IHttpTransport httpTransport;
                RawRequest request = REQ_TRANSLATOR.translate(req, accessTokenType, config, httpMethod, httpPath, requestOptions);
                if (config.isLogReqAtDebug()) {
                    Transport.logReq(request, httpPath, requestOptions.isSupportUpload());
                }
                if ((httpTransport = config.getHttpTransport()) == null) {
                    httpTransport = new OkHttpTransport(OKHttps.defaultClient);
                }
                RawResponse rawResponse = httpTransport.execute(request);
                if (config.isLogReqAtDebug() || accessTokenType != AccessTokenType.None) {
                    if (requestOptions.isSupportDownLoad()) {
                        log.debug("resp,path:{},code:{},header:{}", new Object[]{httpPath, rawResponse.getStatusCode(), rawResponse.getHeaders()});
                    } else {
                        log.debug("resp,path:{},code:{},header:{},body:{}", new Object[]{httpPath, rawResponse.getStatusCode(), rawResponse.getHeaders(), new String(rawResponse.getBody(), StandardCharsets.UTF_8)});
                    }
                }
                if (rawResponse.getStatusCode() == 504) {
                    log.error(String.format("httpMethod:%s,httpPath:%s, server time out,reqId:%s", httpMethod, httpPath, rawResponse.getRequestID()));
                    throw new ServerTimeoutException();
                }
                return rawResponse;
            }
            catch (Exception e) {
                error = e;
                if (accessTokenType == AccessTokenType.None) continue;
                throw e;
            }
        }
        throw error;
    }
}

