// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.google.gson.annotations.SerializedName;

public class PunchTimeRule {
    /**
     * 上班时间
     * <p> 示例值：9:00
     */
    @SerializedName("on_time")
    private String onTime;
    /**
     * 下班时间
     * <p> 示例值：18:00， 第二天凌晨2点， 26:00
     */
    @SerializedName("off_time")
    private String offTime;
    /**
     * 晚到多久记为迟到
     * <p> 示例值：30
     */
    @SerializedName("late_minutes_as_late")
    private Integer lateMinutesAsLate;
    /**
     * 晚到多久记为缺卡
     * <p> 示例值：60
     */
    @SerializedName("late_minutes_as_lack")
    private Integer lateMinutesAsLack;
    /**
     * 最早多久可打上班卡
     * <p> 示例值：60
     */
    @SerializedName("on_advance_minutes")
    private Integer onAdvanceMinutes;
    /**
     * 早退多久记为早退
     * <p> 示例值：30
     */
    @SerializedName("early_minutes_as_early")
    private Integer earlyMinutesAsEarly;
    /**
     * 早退多久记为缺卡
     * <p> 示例值：60
     */
    @SerializedName("early_minutes_as_lack")
    private Integer earlyMinutesAsLack;
    /**
     * 最晚多久可打下班卡
     * <p> 示例值：60
     */
    @SerializedName("off_delay_minutes")
    private Integer offDelayMinutes;
    /**
     * 晚到多久记为严重迟到
     * <p> 示例值：40
     */
    @SerializedName("late_minutes_as_serious_late")
    private Integer lateMinutesAsSeriousLate;

    // builder 开始
    public PunchTimeRule() {
    }

    public PunchTimeRule(Builder builder) {
        /**
         * 上班时间
         * <p> 示例值：9:00
         */
        this.onTime = builder.onTime;
        /**
         * 下班时间
         * <p> 示例值：18:00， 第二天凌晨2点， 26:00
         */
        this.offTime = builder.offTime;
        /**
         * 晚到多久记为迟到
         * <p> 示例值：30
         */
        this.lateMinutesAsLate = builder.lateMinutesAsLate;
        /**
         * 晚到多久记为缺卡
         * <p> 示例值：60
         */
        this.lateMinutesAsLack = builder.lateMinutesAsLack;
        /**
         * 最早多久可打上班卡
         * <p> 示例值：60
         */
        this.onAdvanceMinutes = builder.onAdvanceMinutes;
        /**
         * 早退多久记为早退
         * <p> 示例值：30
         */
        this.earlyMinutesAsEarly = builder.earlyMinutesAsEarly;
        /**
         * 早退多久记为缺卡
         * <p> 示例值：60
         */
        this.earlyMinutesAsLack = builder.earlyMinutesAsLack;
        /**
         * 最晚多久可打下班卡
         * <p> 示例值：60
         */
        this.offDelayMinutes = builder.offDelayMinutes;
        /**
         * 晚到多久记为严重迟到
         * <p> 示例值：40
         */
        this.lateMinutesAsSeriousLate = builder.lateMinutesAsSeriousLate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getOnTime() {
        return this.onTime;
    }

    public void setOnTime(String onTime) {
        this.onTime = onTime;
    }

    public String getOffTime() {
        return this.offTime;
    }

    public void setOffTime(String offTime) {
        this.offTime = offTime;
    }

    public Integer getLateMinutesAsLate() {
        return this.lateMinutesAsLate;
    }

    public void setLateMinutesAsLate(Integer lateMinutesAsLate) {
        this.lateMinutesAsLate = lateMinutesAsLate;
    }

    public Integer getLateMinutesAsLack() {
        return this.lateMinutesAsLack;
    }

    public void setLateMinutesAsLack(Integer lateMinutesAsLack) {
        this.lateMinutesAsLack = lateMinutesAsLack;
    }

    public Integer getOnAdvanceMinutes() {
        return this.onAdvanceMinutes;
    }

    public void setOnAdvanceMinutes(Integer onAdvanceMinutes) {
        this.onAdvanceMinutes = onAdvanceMinutes;
    }

    public Integer getEarlyMinutesAsEarly() {
        return this.earlyMinutesAsEarly;
    }

    public void setEarlyMinutesAsEarly(Integer earlyMinutesAsEarly) {
        this.earlyMinutesAsEarly = earlyMinutesAsEarly;
    }

    public Integer getEarlyMinutesAsLack() {
        return this.earlyMinutesAsLack;
    }

    public void setEarlyMinutesAsLack(Integer earlyMinutesAsLack) {
        this.earlyMinutesAsLack = earlyMinutesAsLack;
    }

    public Integer getOffDelayMinutes() {
        return this.offDelayMinutes;
    }

    public void setOffDelayMinutes(Integer offDelayMinutes) {
        this.offDelayMinutes = offDelayMinutes;
    }

    public Integer getLateMinutesAsSeriousLate() {
        return this.lateMinutesAsSeriousLate;
    }

    public void setLateMinutesAsSeriousLate(Integer lateMinutesAsSeriousLate) {
        this.lateMinutesAsSeriousLate = lateMinutesAsSeriousLate;
    }

    public static class Builder {
        /**
         * 上班时间
         * <p> 示例值：9:00
         */
        private String onTime;
        /**
         * 下班时间
         * <p> 示例值：18:00， 第二天凌晨2点， 26:00
         */
        private String offTime;
        /**
         * 晚到多久记为迟到
         * <p> 示例值：30
         */
        private Integer lateMinutesAsLate;
        /**
         * 晚到多久记为缺卡
         * <p> 示例值：60
         */
        private Integer lateMinutesAsLack;
        /**
         * 最早多久可打上班卡
         * <p> 示例值：60
         */
        private Integer onAdvanceMinutes;
        /**
         * 早退多久记为早退
         * <p> 示例值：30
         */
        private Integer earlyMinutesAsEarly;
        /**
         * 早退多久记为缺卡
         * <p> 示例值：60
         */
        private Integer earlyMinutesAsLack;
        /**
         * 最晚多久可打下班卡
         * <p> 示例值：60
         */
        private Integer offDelayMinutes;
        /**
         * 晚到多久记为严重迟到
         * <p> 示例值：40
         */
        private Integer lateMinutesAsSeriousLate;

        /**
         * 上班时间
         * <p> 示例值：9:00
         *
         * @param onTime
         * @return
         */
        public Builder onTime(String onTime) {
            this.onTime = onTime;
            return this;
        }


        /**
         * 下班时间
         * <p> 示例值：18:00， 第二天凌晨2点， 26:00
         *
         * @param offTime
         * @return
         */
        public Builder offTime(String offTime) {
            this.offTime = offTime;
            return this;
        }


        /**
         * 晚到多久记为迟到
         * <p> 示例值：30
         *
         * @param lateMinutesAsLate
         * @return
         */
        public Builder lateMinutesAsLate(Integer lateMinutesAsLate) {
            this.lateMinutesAsLate = lateMinutesAsLate;
            return this;
        }


        /**
         * 晚到多久记为缺卡
         * <p> 示例值：60
         *
         * @param lateMinutesAsLack
         * @return
         */
        public Builder lateMinutesAsLack(Integer lateMinutesAsLack) {
            this.lateMinutesAsLack = lateMinutesAsLack;
            return this;
        }


        /**
         * 最早多久可打上班卡
         * <p> 示例值：60
         *
         * @param onAdvanceMinutes
         * @return
         */
        public Builder onAdvanceMinutes(Integer onAdvanceMinutes) {
            this.onAdvanceMinutes = onAdvanceMinutes;
            return this;
        }


        /**
         * 早退多久记为早退
         * <p> 示例值：30
         *
         * @param earlyMinutesAsEarly
         * @return
         */
        public Builder earlyMinutesAsEarly(Integer earlyMinutesAsEarly) {
            this.earlyMinutesAsEarly = earlyMinutesAsEarly;
            return this;
        }


        /**
         * 早退多久记为缺卡
         * <p> 示例值：60
         *
         * @param earlyMinutesAsLack
         * @return
         */
        public Builder earlyMinutesAsLack(Integer earlyMinutesAsLack) {
            this.earlyMinutesAsLack = earlyMinutesAsLack;
            return this;
        }


        /**
         * 最晚多久可打下班卡
         * <p> 示例值：60
         *
         * @param offDelayMinutes
         * @return
         */
        public Builder offDelayMinutes(Integer offDelayMinutes) {
            this.offDelayMinutes = offDelayMinutes;
            return this;
        }


        /**
         * 晚到多久记为严重迟到
         * <p> 示例值：40
         *
         * @param lateMinutesAsSeriousLate
         * @return
         */
        public Builder lateMinutesAsSeriousLate(Integer lateMinutesAsSeriousLate) {
            this.lateMinutesAsSeriousLate = lateMinutesAsSeriousLate;
            return this;
        }


        public PunchTimeRule build() {
            return new PunchTimeRule(this);
        }
    }
}
