// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.contact.v3.model;

import com.google.gson.annotations.SerializedName;

public class PatchGroupReqBody {
    /**
     * 用户组的名字，企业内唯一，最大长度：100 字符
     * <p> 示例值：外包 IT 用户组
     */
    @SerializedName("name")
    private String name;
    /**
     * 用户组描述信息;最大长度：500 字
     * <p> 示例值：IT 外包用户组，需要进行细粒度权限管控
     */
    @SerializedName("description")
    private String description;
    /**
     * 动态用户组的规则
     * <p> 示例值：
     */
    @SerializedName("dynamic_group_rule")
    private DynamicGroupRule dynamicGroupRule;
    /**
     * 用户组指定可见范围
     * <p> 示例值：
     */
    @SerializedName("visible_scope")
    private GroupVisibleScope visibleScope;

    // builder 开始
    public PatchGroupReqBody() {
    }

    public PatchGroupReqBody(Builder builder) {
        /**
         * 用户组的名字，企业内唯一，最大长度：100 字符
         * <p> 示例值：外包 IT 用户组
         */
        this.name = builder.name;
        /**
         * 用户组描述信息;最大长度：500 字
         * <p> 示例值：IT 外包用户组，需要进行细粒度权限管控
         */
        this.description = builder.description;
        /**
         * 动态用户组的规则
         * <p> 示例值：
         */
        this.dynamicGroupRule = builder.dynamicGroupRule;
        /**
         * 用户组指定可见范围
         * <p> 示例值：
         */
        this.visibleScope = builder.visibleScope;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DynamicGroupRule getDynamicGroupRule() {
        return this.dynamicGroupRule;
    }

    public void setDynamicGroupRule(DynamicGroupRule dynamicGroupRule) {
        this.dynamicGroupRule = dynamicGroupRule;
    }

    public GroupVisibleScope getVisibleScope() {
        return this.visibleScope;
    }

    public void setVisibleScope(GroupVisibleScope visibleScope) {
        this.visibleScope = visibleScope;
    }

    public static class Builder {
        /**
         * 用户组的名字，企业内唯一，最大长度：100 字符
         * <p> 示例值：外包 IT 用户组
         */
        private String name;
        /**
         * 用户组描述信息;最大长度：500 字
         * <p> 示例值：IT 外包用户组，需要进行细粒度权限管控
         */
        private String description;
        /**
         * 动态用户组的规则
         * <p> 示例值：
         */
        private DynamicGroupRule dynamicGroupRule;
        /**
         * 用户组指定可见范围
         * <p> 示例值：
         */
        private GroupVisibleScope visibleScope;

        /**
         * 用户组的名字，企业内唯一，最大长度：100 字符
         * <p> 示例值：外包 IT 用户组
         *
         * @param name
         * @return
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }


        /**
         * 用户组描述信息;最大长度：500 字
         * <p> 示例值：IT 外包用户组，需要进行细粒度权限管控
         *
         * @param description
         * @return
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }


        /**
         * 动态用户组的规则
         * <p> 示例值：
         *
         * @param dynamicGroupRule
         * @return
         */
        public Builder dynamicGroupRule(DynamicGroupRule dynamicGroupRule) {
            this.dynamicGroupRule = dynamicGroupRule;
            return this;
        }


        /**
         * 用户组指定可见范围
         * <p> 示例值：
         *
         * @param visibleScope
         * @return
         */
        public Builder visibleScope(GroupVisibleScope visibleScope) {
            this.visibleScope = visibleScope;
            return this;
        }


        public PatchGroupReqBody build() {
            return new PatchGroupReqBody(this);
        }
    }
}
