// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;

import com.google.gson.annotations.SerializedName;

public class Subdivision {
    /**
     * 省份/行政区id
     * <p> 示例值：12
     */
    @SerializedName("id")
    private String id;
    /**
     * 省份/行政区名称
     * <p> 示例值：
     */
    @SerializedName("name")
    private I18n[] name;
    /**
     * 所属国家/地区id，详细信息可通过【查询国家/地区信息】接口查询获得
     * <p> 示例值：12
     */
    @SerializedName("country_region_id")
    private String countryRegionId;
    /**
     * 行政区类型，枚举值可通过文档【飞书人事枚举常量】行政区类型（subdivision_type）枚举定义部分获得
     * <p> 示例值：
     */
    @SerializedName("subdivision_type")
    private Enum subdivisionType;

    // builder 开始
    public Subdivision() {
    }

    public Subdivision(Builder builder) {
        /**
         * 省份/行政区id
         * <p> 示例值：12
         */
        this.id = builder.id;
        /**
         * 省份/行政区名称
         * <p> 示例值：
         */
        this.name = builder.name;
        /**
         * 所属国家/地区id，详细信息可通过【查询国家/地区信息】接口查询获得
         * <p> 示例值：12
         */
        this.countryRegionId = builder.countryRegionId;
        /**
         * 行政区类型，枚举值可通过文档【飞书人事枚举常量】行政区类型（subdivision_type）枚举定义部分获得
         * <p> 示例值：
         */
        this.subdivisionType = builder.subdivisionType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public I18n[] getName() {
        return this.name;
    }

    public void setName(I18n[] name) {
        this.name = name;
    }

    public String getCountryRegionId() {
        return this.countryRegionId;
    }

    public void setCountryRegionId(String countryRegionId) {
        this.countryRegionId = countryRegionId;
    }

    public Enum getSubdivisionType() {
        return this.subdivisionType;
    }

    public void setSubdivisionType(Enum subdivisionType) {
        this.subdivisionType = subdivisionType;
    }

    public static class Builder {
        /**
         * 省份/行政区id
         * <p> 示例值：12
         */
        private String id;
        /**
         * 省份/行政区名称
         * <p> 示例值：
         */
        private I18n[] name;
        /**
         * 所属国家/地区id，详细信息可通过【查询国家/地区信息】接口查询获得
         * <p> 示例值：12
         */
        private String countryRegionId;
        /**
         * 行政区类型，枚举值可通过文档【飞书人事枚举常量】行政区类型（subdivision_type）枚举定义部分获得
         * <p> 示例值：
         */
        private Enum subdivisionType;

        /**
         * 省份/行政区id
         * <p> 示例值：12
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 省份/行政区名称
         * <p> 示例值：
         *
         * @param name
         * @return
         */
        public Builder name(I18n[] name) {
            this.name = name;
            return this;
        }


        /**
         * 所属国家/地区id，详细信息可通过【查询国家/地区信息】接口查询获得
         * <p> 示例值：12
         *
         * @param countryRegionId
         * @return
         */
        public Builder countryRegionId(String countryRegionId) {
            this.countryRegionId = countryRegionId;
            return this;
        }


        /**
         * 行政区类型，枚举值可通过文档【飞书人事枚举常量】行政区类型（subdivision_type）枚举定义部分获得
         * <p> 示例值：
         *
         * @param subdivisionType
         * @return
         */
        public Builder subdivisionType(Enum subdivisionType) {
            this.subdivisionType = subdivisionType;
            return this;
        }


        public Subdivision build() {
            return new Subdivision(this);
        }
    }
}
