// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Query;

public class ListJobRequirementReq {
    /**
     * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
     * <p> 示例值：1231231987
     */
    @Query
    @SerializedName("page_token")
    private String pageToken;
    /**
     * 每页获取记录数量，最大100
     * <p> 示例值：20
     */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
    /**
     * 职位ID
     * <p> 示例值：6001
     */
    @Query
    @SerializedName("job_id")
    private String jobId;
    /**
     * 起始创建时间，传入毫秒级时间戳
     * <p> 示例值：1658980233000
     */
    @Query
    @SerializedName("create_time_begin")
    private String createTimeBegin;
    /**
     * 截止创建时间，传入毫秒级时间戳
     * <p> 示例值：1658980233000
     */
    @Query
    @SerializedName("create_time_end")
    private String createTimeEnd;
    /**
     * 起始更新时间，传入毫秒级时间戳
     * <p> 示例值：1658980233000
     */
    @Query
    @SerializedName("update_time_begin")
    private String updateTimeBegin;
    /**
     * 截止更新时间，传入毫秒级时间戳
     * <p> 示例值：1658980233000
     */
    @Query
    @SerializedName("update_time_end")
    private String updateTimeEnd;
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 此次调用中使用的部门 ID 的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("department_id_type")
    private String departmentIdType;

    // builder 开始
    public ListJobRequirementReq() {
    }

    public ListJobRequirementReq(Builder builder) {
        /**
         * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
         * <p> 示例值：1231231987
         */
        this.pageToken = builder.pageToken;
        /**
         * 每页获取记录数量，最大100
         * <p> 示例值：20
         */
        this.pageSize = builder.pageSize;
        /**
         * 职位ID
         * <p> 示例值：6001
         */
        this.jobId = builder.jobId;
        /**
         * 起始创建时间，传入毫秒级时间戳
         * <p> 示例值：1658980233000
         */
        this.createTimeBegin = builder.createTimeBegin;
        /**
         * 截止创建时间，传入毫秒级时间戳
         * <p> 示例值：1658980233000
         */
        this.createTimeEnd = builder.createTimeEnd;
        /**
         * 起始更新时间，传入毫秒级时间戳
         * <p> 示例值：1658980233000
         */
        this.updateTimeBegin = builder.updateTimeBegin;
        /**
         * 截止更新时间，传入毫秒级时间戳
         * <p> 示例值：1658980233000
         */
        this.updateTimeEnd = builder.updateTimeEnd;
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         */
        this.userIdType = builder.userIdType;
        /**
         * 此次调用中使用的部门 ID 的类型
         * <p> 示例值：
         */
        this.departmentIdType = builder.departmentIdType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getCreateTimeBegin() {
        return this.createTimeBegin;
    }

    public void setCreateTimeBegin(String createTimeBegin) {
        this.createTimeBegin = createTimeBegin;
    }

    public String getCreateTimeEnd() {
        return this.createTimeEnd;
    }

    public void setCreateTimeEnd(String createTimeEnd) {
        this.createTimeEnd = createTimeEnd;
    }

    public String getUpdateTimeBegin() {
        return this.updateTimeBegin;
    }

    public void setUpdateTimeBegin(String updateTimeBegin) {
        this.updateTimeBegin = updateTimeBegin;
    }

    public String getUpdateTimeEnd() {
        return this.updateTimeEnd;
    }

    public void setUpdateTimeEnd(String updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getDepartmentIdType() {
        return this.departmentIdType;
    }

    public void setDepartmentIdType(String departmentIdType) {
        this.departmentIdType = departmentIdType;
    }

    public static class Builder {
        private String pageToken; // 页码标识，获取第一页传空，每次查询会返回下一页的page_token
        private Integer pageSize; // 每页获取记录数量，最大100
        private String jobId; // 职位ID
        private String createTimeBegin; // 起始创建时间，传入毫秒级时间戳
        private String createTimeEnd; // 截止创建时间，传入毫秒级时间戳
        private String updateTimeBegin; // 起始更新时间，传入毫秒级时间戳
        private String updateTimeEnd; // 截止更新时间，传入毫秒级时间戳
        private String userIdType; // 此次调用中使用的用户ID的类型
        private String departmentIdType; // 此次调用中使用的部门 ID 的类型


        /**
         * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
         * <p> 示例值：1231231987
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        /**
         * 每页获取记录数量，最大100
         * <p> 示例值：20
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 职位ID
         * <p> 示例值：6001
         *
         * @param jobId
         * @return
         */
        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }


        /**
         * 起始创建时间，传入毫秒级时间戳
         * <p> 示例值：1658980233000
         *
         * @param createTimeBegin
         * @return
         */
        public Builder createTimeBegin(String createTimeBegin) {
            this.createTimeBegin = createTimeBegin;
            return this;
        }


        /**
         * 截止创建时间，传入毫秒级时间戳
         * <p> 示例值：1658980233000
         *
         * @param createTimeEnd
         * @return
         */
        public Builder createTimeEnd(String createTimeEnd) {
            this.createTimeEnd = createTimeEnd;
            return this;
        }


        /**
         * 起始更新时间，传入毫秒级时间戳
         * <p> 示例值：1658980233000
         *
         * @param updateTimeBegin
         * @return
         */
        public Builder updateTimeBegin(String updateTimeBegin) {
            this.updateTimeBegin = updateTimeBegin;
            return this;
        }


        /**
         * 截止更新时间，传入毫秒级时间戳
         * <p> 示例值：1658980233000
         *
         * @param updateTimeEnd
         * @return
         */
        public Builder updateTimeEnd(String updateTimeEnd) {
            this.updateTimeEnd = updateTimeEnd;
            return this;
        }


        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }


        /**
         * 此次调用中使用的部门 ID 的类型
         * <p> 示例值：
         *
         * @param departmentIdType
         * @return
         */
        public Builder departmentIdType(String departmentIdType) {
            this.departmentIdType = departmentIdType;
            return this;
        }

        public ListJobRequirementReq build() {
            return new ListJobRequirementReq(this);
        }
    }
}
