// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.mail.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

public class BatchCreateMailgroupManagerReq {
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：open_id
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    /**
     * 邮件组ID或邮箱地址
     * <p> 示例值：xxxxxx 或 test_mail_group@xx.xx
     */
    @Path
    @SerializedName("mailgroup_id")
    private String mailgroupId;
    @Body
    private BatchCreateMailgroupManagerReqBody body;

    // builder 开始
    public BatchCreateMailgroupManagerReq() {
    }

    public BatchCreateMailgroupManagerReq(Builder builder) {
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：open_id
         */
        this.userIdType = builder.userIdType;
        /**
         * 邮件组ID或邮箱地址
         * <p> 示例值：xxxxxx 或 test_mail_group@xx.xx
         */
        this.mailgroupId = builder.mailgroupId;
        this.body = builder.body;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getMailgroupId() {
        return this.mailgroupId;
    }

    public void setMailgroupId(String mailgroupId) {
        this.mailgroupId = mailgroupId;
    }

    public BatchCreateMailgroupManagerReqBody getBatchCreateMailgroupManagerReqBody() {
        return this.body;
    }

    public void setBatchCreateMailgroupManagerReqBody(BatchCreateMailgroupManagerReqBody body) {
        this.body = body;
    }

    public static class Builder {
        private String userIdType; // 此次调用中使用的用户ID的类型
        private String mailgroupId; // 邮件组ID或邮箱地址
        private BatchCreateMailgroupManagerReqBody body;

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：open_id
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：open_id
         *
         * @param userIdType {@link com.lark.oapi.service.mail.v1.enums.BatchCreateMailgroupManagerUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.mail.v1.enums.BatchCreateMailgroupManagerUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        /**
         * 邮件组ID或邮箱地址
         * <p> 示例值：xxxxxx 或 test_mail_group@xx.xx
         *
         * @param mailgroupId
         * @return
         */
        public Builder mailgroupId(String mailgroupId) {
            this.mailgroupId = mailgroupId;
            return this;
        }

        public BatchCreateMailgroupManagerReqBody getBatchCreateMailgroupManagerReqBody() {
            return this.body;
        }

        /**
         * body
         *
         * @param body
         * @return
         */
        public Builder batchCreateMailgroupManagerReqBody(BatchCreateMailgroupManagerReqBody body) {
            this.body = body;
            return this;
        }

        public BatchCreateMailgroupManagerReq build() {
            return new BatchCreateMailgroupManagerReq(this);
        }
    }
}
