// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.search.v2.model;

import com.google.gson.annotations.SerializedName;

public class LlmModelConfig {
    /**
     * 模型名称
     * <p> 示例值：gpt-3.5-turbo
     */
    @SerializedName("model_name")
    private String modelName;
    /**
     * 自定义的问答prompt，占位符格式和go标准库-text/template保持一致
     * <p> 示例值：请根据以下文档回答问题，请仅依靠提供的文档段落回答问题。\n{{ range $index, $p := .Passages }}\n段落{{ $index }}：\n{{ $p }}\n{{ end }}\n请回答：\n{{ .Query }}
     */
    @SerializedName("prompt")
    private String prompt;
    /**
     * 模型接收的最大token数
     * <p> 示例值：4096
     */
    @SerializedName("max_token")
    private Integer maxToken;
    /**
     * 模型生成的温度系数
     * <p> 示例值：0.3
     */
    @SerializedName("temperature")
    private Double temperature;

    // builder 开始
    public LlmModelConfig() {
    }

    public LlmModelConfig(Builder builder) {
        /**
         * 模型名称
         * <p> 示例值：gpt-3.5-turbo
         */
        this.modelName = builder.modelName;
        /**
         * 自定义的问答prompt，占位符格式和go标准库-text/template保持一致
         * <p> 示例值：请根据以下文档回答问题，请仅依靠提供的文档段落回答问题。\n{{ range $index, $p := .Passages }}\n段落{{ $index }}：\n{{ $p }}\n{{ end }}\n请回答：\n{{ .Query }}
         */
        this.prompt = builder.prompt;
        /**
         * 模型接收的最大token数
         * <p> 示例值：4096
         */
        this.maxToken = builder.maxToken;
        /**
         * 模型生成的温度系数
         * <p> 示例值：0.3
         */
        this.temperature = builder.temperature;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getMaxToken() {
        return this.maxToken;
    }

    public void setMaxToken(Integer maxToken) {
        this.maxToken = maxToken;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public static class Builder {
        /**
         * 模型名称
         * <p> 示例值：gpt-3.5-turbo
         */
        private String modelName;
        /**
         * 自定义的问答prompt，占位符格式和go标准库-text/template保持一致
         * <p> 示例值：请根据以下文档回答问题，请仅依靠提供的文档段落回答问题。\n{{ range $index, $p := .Passages }}\n段落{{ $index }}：\n{{ $p }}\n{{ end }}\n请回答：\n{{ .Query }}
         */
        private String prompt;
        /**
         * 模型接收的最大token数
         * <p> 示例值：4096
         */
        private Integer maxToken;
        /**
         * 模型生成的温度系数
         * <p> 示例值：0.3
         */
        private Double temperature;

        /**
         * 模型名称
         * <p> 示例值：gpt-3.5-turbo
         *
         * @param modelName
         * @return
         */
        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }


        /**
         * 自定义的问答prompt，占位符格式和go标准库-text/template保持一致
         * <p> 示例值：请根据以下文档回答问题，请仅依靠提供的文档段落回答问题。\n{{ range $index, $p := .Passages }}\n段落{{ $index }}：\n{{ $p }}\n{{ end }}\n请回答：\n{{ .Query }}
         *
         * @param prompt
         * @return
         */
        public Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }


        /**
         * 模型接收的最大token数
         * <p> 示例值：4096
         *
         * @param maxToken
         * @return
         */
        public Builder maxToken(Integer maxToken) {
            this.maxToken = maxToken;
            return this;
        }


        /**
         * 模型生成的温度系数
         * <p> 示例值：0.3
         *
         * @param temperature
         * @return
         */
        public Builder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }


        public LlmModelConfig build() {
            return new LlmModelConfig(this);
        }
    }
}
