// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.sheets.v3.model;

import com.google.gson.annotations.SerializedName;

public class SingleOption {
    /**
     * 单选类型
     * <p> 示例值：OneOfList
     */
    @SerializedName("type")
    private String type;
    /**
     * 引用数据的范围，当type=OneOfRange时必须存在
     * <p> 示例值：as8jJ0!A1:B2
     */
    @SerializedName("range")
    private String range;
    /**
     * 选项
     * <p> 示例值：
     */
    @SerializedName("data_validation_values")
    private DataValidationValue[] dataValidationValues;
    /**
     * 属性
     * <p> 示例值：
     */
    @SerializedName("properties")
    private OptionProperties properties;

    // builder 开始
    public SingleOption() {
    }

    public SingleOption(Builder builder) {
        /**
         * 单选类型
         * <p> 示例值：OneOfList
         */
        this.type = builder.type;
        /**
         * 引用数据的范围，当type=OneOfRange时必须存在
         * <p> 示例值：as8jJ0!A1:B2
         */
        this.range = builder.range;
        /**
         * 选项
         * <p> 示例值：
         */
        this.dataValidationValues = builder.dataValidationValues;
        /**
         * 属性
         * <p> 示例值：
         */
        this.properties = builder.properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public DataValidationValue[] getDataValidationValues() {
        return this.dataValidationValues;
    }

    public void setDataValidationValues(DataValidationValue[] dataValidationValues) {
        this.dataValidationValues = dataValidationValues;
    }

    public OptionProperties getProperties() {
        return this.properties;
    }

    public void setProperties(OptionProperties properties) {
        this.properties = properties;
    }

    public static class Builder {
        /**
         * 单选类型
         * <p> 示例值：OneOfList
         */
        private String type;
        /**
         * 引用数据的范围，当type=OneOfRange时必须存在
         * <p> 示例值：as8jJ0!A1:B2
         */
        private String range;
        /**
         * 选项
         * <p> 示例值：
         */
        private DataValidationValue[] dataValidationValues;
        /**
         * 属性
         * <p> 示例值：
         */
        private OptionProperties properties;

        /**
         * 单选类型
         * <p> 示例值：OneOfList
         *
         * @param type
         * @return
         */
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        /**
         * 单选类型
         * <p> 示例值：OneOfList
         *
         * @param type {@link com.lark.oapi.service.sheets.v3.enums.SingleOptionSingleOptionEnum}
         * @return
         */
        public Builder type(com.lark.oapi.service.sheets.v3.enums.SingleOptionSingleOptionEnum type) {
            this.type = type.getValue();
            return this;
        }


        /**
         * 引用数据的范围，当type=OneOfRange时必须存在
         * <p> 示例值：as8jJ0!A1:B2
         *
         * @param range
         * @return
         */
        public Builder range(String range) {
            this.range = range;
            return this;
        }


        /**
         * 选项
         * <p> 示例值：
         *
         * @param dataValidationValues
         * @return
         */
        public Builder dataValidationValues(DataValidationValue[] dataValidationValues) {
            this.dataValidationValues = dataValidationValues;
            return this;
        }


        /**
         * 属性
         * <p> 示例值：
         *
         * @param properties
         * @return
         */
        public Builder properties(OptionProperties properties) {
            this.properties = properties;
            return this;
        }


        public SingleOption build() {
            return new SingleOption(this);
        }
    }
}
