// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Query;

public class GetParticipantListReq {
    /**
     * 会议开始时间（unix时间，单位sec）
     * <p> 示例值：1655276858
     */
    @Query
    @SerializedName("meeting_start_time")
    private String meetingStartTime;
    /**
     * 会议结束时间（unix时间，单位sec）
     * <p> 示例值：1655276858
     */
    @Query
    @SerializedName("meeting_end_time")
    private String meetingEndTime;
    /**
     * 9位会议号
     * <p> 示例值：123456789
     */
    @Query
    @SerializedName("meeting_no")
    private String meetingNo;
    /**
     * 按参会Lark用户筛选（最多一个筛选条件）
     * <p> 示例值：ou_3ec3f6a28a0d08c45d895276e8e5e19b
     */
    @Query
    @SerializedName("user_id")
    private String userId;
    /**
     * 按参会Rooms筛选（最多一个筛选条件）
     * <p> 示例值：omm_eada1d61a550955240c28757e7dec3af
     */
    @Query
    @SerializedName("room_id")
    private String roomId;
    /**
     * 分页尺寸大小
     * <p> 示例值：20
     */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
    /**
     * 分页标记,第一次请求不填,表示从头开始遍历.下次遍历可采用该 page_token获取查询结果
     * <p> 示例值：
     */
    @Query
    @SerializedName("page_token")
    private String pageToken;
    /**
     * 此次调用中使用的用户ID的类型
     * <p> 示例值：
     */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;

    // builder 开始
    public GetParticipantListReq() {
    }

    public GetParticipantListReq(Builder builder) {
        /**
         * 会议开始时间（unix时间，单位sec）
         * <p> 示例值：1655276858
         */
        this.meetingStartTime = builder.meetingStartTime;
        /**
         * 会议结束时间（unix时间，单位sec）
         * <p> 示例值：1655276858
         */
        this.meetingEndTime = builder.meetingEndTime;
        /**
         * 9位会议号
         * <p> 示例值：123456789
         */
        this.meetingNo = builder.meetingNo;
        /**
         * 按参会Lark用户筛选（最多一个筛选条件）
         * <p> 示例值：ou_3ec3f6a28a0d08c45d895276e8e5e19b
         */
        this.userId = builder.userId;
        /**
         * 按参会Rooms筛选（最多一个筛选条件）
         * <p> 示例值：omm_eada1d61a550955240c28757e7dec3af
         */
        this.roomId = builder.roomId;
        /**
         * 分页尺寸大小
         * <p> 示例值：20
         */
        this.pageSize = builder.pageSize;
        /**
         * 分页标记,第一次请求不填,表示从头开始遍历.下次遍历可采用该 page_token获取查询结果
         * <p> 示例值：
         */
        this.pageToken = builder.pageToken;
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         */
        this.userIdType = builder.userIdType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getMeetingStartTime() {
        return this.meetingStartTime;
    }

    public void setMeetingStartTime(String meetingStartTime) {
        this.meetingStartTime = meetingStartTime;
    }

    public String getMeetingEndTime() {
        return this.meetingEndTime;
    }

    public void setMeetingEndTime(String meetingEndTime) {
        this.meetingEndTime = meetingEndTime;
    }

    public String getMeetingNo() {
        return this.meetingNo;
    }

    public void setMeetingNo(String meetingNo) {
        this.meetingNo = meetingNo;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public static class Builder {
        private String meetingStartTime; // 会议开始时间（unix时间，单位sec）
        private String meetingEndTime; // 会议结束时间（unix时间，单位sec）
        private String meetingNo; // 9位会议号
        private String userId; // 按参会Lark用户筛选（最多一个筛选条件）
        private String roomId; // 按参会Rooms筛选（最多一个筛选条件）
        private Integer pageSize; // 分页尺寸大小
        private String pageToken; // 分页标记,第一次请求不填,表示从头开始遍历.下次遍历可采用该 page_token获取查询结果
        private String userIdType; // 此次调用中使用的用户ID的类型


        /**
         * 会议开始时间（unix时间，单位sec）
         * <p> 示例值：1655276858
         *
         * @param meetingStartTime
         * @return
         */
        public Builder meetingStartTime(String meetingStartTime) {
            this.meetingStartTime = meetingStartTime;
            return this;
        }


        /**
         * 会议结束时间（unix时间，单位sec）
         * <p> 示例值：1655276858
         *
         * @param meetingEndTime
         * @return
         */
        public Builder meetingEndTime(String meetingEndTime) {
            this.meetingEndTime = meetingEndTime;
            return this;
        }


        /**
         * 9位会议号
         * <p> 示例值：123456789
         *
         * @param meetingNo
         * @return
         */
        public Builder meetingNo(String meetingNo) {
            this.meetingNo = meetingNo;
            return this;
        }


        /**
         * 按参会Lark用户筛选（最多一个筛选条件）
         * <p> 示例值：ou_3ec3f6a28a0d08c45d895276e8e5e19b
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 按参会Rooms筛选（最多一个筛选条件）
         * <p> 示例值：omm_eada1d61a550955240c28757e7dec3af
         *
         * @param roomId
         * @return
         */
        public Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }


        /**
         * 分页尺寸大小
         * <p> 示例值：20
         *
         * @param pageSize
         * @return
         */
        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }


        /**
         * 分页标记,第一次请求不填,表示从头开始遍历.下次遍历可采用该 page_token获取查询结果
         * <p> 示例值：
         *
         * @param pageToken
         * @return
         */
        public Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }


        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType
         * @return
         */
        public Builder userIdType(String userIdType) {
            this.userIdType = userIdType;
            return this;
        }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         *
         * @param userIdType {@link com.lark.oapi.service.vc.v1.enums.GetParticipantListUserIdTypeEnum}
         * @return
         */
        public Builder userIdType(com.lark.oapi.service.vc.v1.enums.GetParticipantListUserIdTypeEnum userIdType) {
            this.userIdType = userIdType.getValue();
            return this;
        }

        public GetParticipantListReq build() {
            return new GetParticipantListReq(this);
        }
    }
}
