// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.vc.v1.model;

import com.google.gson.annotations.SerializedName;

public class ReserveScopeConfig {
    /**
     * 可预定成员范围：0 代表部分成员，1 代表全部成员。;<b>说明</b>：;1.  此值必填。;2.  当设置为 0 时，至少需要 1 个预定部门或预定人
     * <p> 示例值：0
     */
    @SerializedName("allow_all_users")
    private Integer allowAllUsers;
    /**
     * 可预定成员列表
     * <p> 示例值：[{user_id:"ou_e8bce6c3935ef1fc1b432992fd9d3db8"}]
     */
    @SerializedName("allow_users")
    private SubscribeUser[] allowUsers;
    /**
     * 可预定部门列表
     * <p> 示例值：[{department_id:"od-5c07f0c117cf8795f25610a69363ce31"}]
     */
    @SerializedName("allow_depts")
    private SubscribeDepartment[] allowDepts;

    // builder 开始
    public ReserveScopeConfig() {
    }

    public ReserveScopeConfig(Builder builder) {
        /**
         * 可预定成员范围：0 代表部分成员，1 代表全部成员。;<b>说明</b>：;1.  此值必填。;2.  当设置为 0 时，至少需要 1 个预定部门或预定人
         * <p> 示例值：0
         */
        this.allowAllUsers = builder.allowAllUsers;
        /**
         * 可预定成员列表
         * <p> 示例值：[{user_id:"ou_e8bce6c3935ef1fc1b432992fd9d3db8"}]
         */
        this.allowUsers = builder.allowUsers;
        /**
         * 可预定部门列表
         * <p> 示例值：[{department_id:"od-5c07f0c117cf8795f25610a69363ce31"}]
         */
        this.allowDepts = builder.allowDepts;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getAllowAllUsers() {
        return this.allowAllUsers;
    }

    public void setAllowAllUsers(Integer allowAllUsers) {
        this.allowAllUsers = allowAllUsers;
    }

    public SubscribeUser[] getAllowUsers() {
        return this.allowUsers;
    }

    public void setAllowUsers(SubscribeUser[] allowUsers) {
        this.allowUsers = allowUsers;
    }

    public SubscribeDepartment[] getAllowDepts() {
        return this.allowDepts;
    }

    public void setAllowDepts(SubscribeDepartment[] allowDepts) {
        this.allowDepts = allowDepts;
    }

    public static class Builder {
        /**
         * 可预定成员范围：0 代表部分成员，1 代表全部成员。;<b>说明</b>：;1.  此值必填。;2.  当设置为 0 时，至少需要 1 个预定部门或预定人
         * <p> 示例值：0
         */
        private Integer allowAllUsers;
        /**
         * 可预定成员列表
         * <p> 示例值：[{user_id:"ou_e8bce6c3935ef1fc1b432992fd9d3db8"}]
         */
        private SubscribeUser[] allowUsers;
        /**
         * 可预定部门列表
         * <p> 示例值：[{department_id:"od-5c07f0c117cf8795f25610a69363ce31"}]
         */
        private SubscribeDepartment[] allowDepts;

        /**
         * 可预定成员范围：0 代表部分成员，1 代表全部成员。;<b>说明</b>：;1.  此值必填。;2.  当设置为 0 时，至少需要 1 个预定部门或预定人
         * <p> 示例值：0
         *
         * @param allowAllUsers
         * @return
         */
        public Builder allowAllUsers(Integer allowAllUsers) {
            this.allowAllUsers = allowAllUsers;
            return this;
        }


        /**
         * 可预定成员列表
         * <p> 示例值：[{user_id:"ou_e8bce6c3935ef1fc1b432992fd9d3db8"}]
         *
         * @param allowUsers
         * @return
         */
        public Builder allowUsers(SubscribeUser[] allowUsers) {
            this.allowUsers = allowUsers;
            return this;
        }


        /**
         * 可预定部门列表
         * <p> 示例值：[{department_id:"od-5c07f0c117cf8795f25610a69363ce31"}]
         *
         * @param allowDepts
         * @return
         */
        public Builder allowDepts(SubscribeDepartment[] allowDepts) {
            this.allowDepts = allowDepts;
            return this;
        }


        public ReserveScopeConfig build() {
            return new ReserveScopeConfig(this);
        }
    }
}
