// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.workplace.v1.model;

import com.google.gson.annotations.SerializedName;

public class CustomWorkplaceAccessData {
    /**
     * 定制工作台ID
     * <p> 示例值：tpl_645b003aaa40001435b2ddw
     */
    @SerializedName("custom_workplace_id")
    private String customWorkplaceId;
    /**
     * 访问数据
     * <p> 示例值：
     */
    @SerializedName("access_data")
    private AccessData accessData;
    /**
     * 时间,精确到天,格式yyyy-MM-dd
     * <p> 示例值：2023-03-12
     */
    @SerializedName("date")
    private String date;
    /**
     * 定制工作台多语言名字。
     * <p> 示例值：
     */
    @SerializedName("custom_workplace_name")
    private I18nName[] customWorkplaceName;

    // builder 开始
    public CustomWorkplaceAccessData() {
    }

    public CustomWorkplaceAccessData(Builder builder) {
        /**
         * 定制工作台ID
         * <p> 示例值：tpl_645b003aaa40001435b2ddw
         */
        this.customWorkplaceId = builder.customWorkplaceId;
        /**
         * 访问数据
         * <p> 示例值：
         */
        this.accessData = builder.accessData;
        /**
         * 时间,精确到天,格式yyyy-MM-dd
         * <p> 示例值：2023-03-12
         */
        this.date = builder.date;
        /**
         * 定制工作台多语言名字。
         * <p> 示例值：
         */
        this.customWorkplaceName = builder.customWorkplaceName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCustomWorkplaceId() {
        return this.customWorkplaceId;
    }

    public void setCustomWorkplaceId(String customWorkplaceId) {
        this.customWorkplaceId = customWorkplaceId;
    }

    public AccessData getAccessData() {
        return this.accessData;
    }

    public void setAccessData(AccessData accessData) {
        this.accessData = accessData;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public I18nName[] getCustomWorkplaceName() {
        return this.customWorkplaceName;
    }

    public void setCustomWorkplaceName(I18nName[] customWorkplaceName) {
        this.customWorkplaceName = customWorkplaceName;
    }

    public static class Builder {
        /**
         * 定制工作台ID
         * <p> 示例值：tpl_645b003aaa40001435b2ddw
         */
        private String customWorkplaceId;
        /**
         * 访问数据
         * <p> 示例值：
         */
        private AccessData accessData;
        /**
         * 时间,精确到天,格式yyyy-MM-dd
         * <p> 示例值：2023-03-12
         */
        private String date;
        /**
         * 定制工作台多语言名字。
         * <p> 示例值：
         */
        private I18nName[] customWorkplaceName;

        /**
         * 定制工作台ID
         * <p> 示例值：tpl_645b003aaa40001435b2ddw
         *
         * @param customWorkplaceId
         * @return
         */
        public Builder customWorkplaceId(String customWorkplaceId) {
            this.customWorkplaceId = customWorkplaceId;
            return this;
        }


        /**
         * 访问数据
         * <p> 示例值：
         *
         * @param accessData
         * @return
         */
        public Builder accessData(AccessData accessData) {
            this.accessData = accessData;
            return this;
        }


        /**
         * 时间,精确到天,格式yyyy-MM-dd
         * <p> 示例值：2023-03-12
         *
         * @param date
         * @return
         */
        public Builder date(String date) {
            this.date = date;
            return this;
        }


        /**
         * 定制工作台多语言名字。
         * <p> 示例值：
         *
         * @param customWorkplaceName
         * @return
         */
        public Builder customWorkplaceName(I18nName[] customWorkplaceName) {
            this.customWorkplaceName = customWorkplaceName;
            return this;
        }


        public CustomWorkplaceAccessData build() {
            return new CustomWorkplaceAccessData(this);
        }
    }
}
