// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.workplace.v1.model;

import com.google.gson.annotations.SerializedName;

public class WorkplaceTenantNotification {
    /**
     * 通知id
     * <p> 示例值：own_xxxxxxxxxxxxxxxx
     */
    @SerializedName("notification_id")
    private String notificationId;
    /**
     * 通知内容 json 格式
     * <p> 示例值：{\"pc_notification\":{\"config\":{\"width\":500,\"height\":500},\"i18n_elements\":{\"zh_cn\":[{\"tag\":\"img\",\"url\":\"https://www.feishu.cn\",\"img_key\":\"test\"}]}}}
     */
    @SerializedName("content")
    private String content;
    /**
     * 自动过期删除的时间戳(秒)
     * <p> 示例值：1739717852
     */
    @SerializedName("expire_time")
    private String expireTime;
    /**
     * 配置可接收到通知的规则
     * <p> 示例值：
     */
    @SerializedName("rule")
    private Rule rule;

    // builder 开始
    public WorkplaceTenantNotification() {
    }

    public WorkplaceTenantNotification(Builder builder) {
        /**
         * 通知id
         * <p> 示例值：own_xxxxxxxxxxxxxxxx
         */
        this.notificationId = builder.notificationId;
        /**
         * 通知内容 json 格式
         * <p> 示例值：{\"pc_notification\":{\"config\":{\"width\":500,\"height\":500},\"i18n_elements\":{\"zh_cn\":[{\"tag\":\"img\",\"url\":\"https://www.feishu.cn\",\"img_key\":\"test\"}]}}}
         */
        this.content = builder.content;
        /**
         * 自动过期删除的时间戳(秒)
         * <p> 示例值：1739717852
         */
        this.expireTime = builder.expireTime;
        /**
         * 配置可接收到通知的规则
         * <p> 示例值：
         */
        this.rule = builder.rule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(String notificationId) {
        this.notificationId = notificationId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public static class Builder {
        /**
         * 通知id
         * <p> 示例值：own_xxxxxxxxxxxxxxxx
         */
        private String notificationId;
        /**
         * 通知内容 json 格式
         * <p> 示例值：{\"pc_notification\":{\"config\":{\"width\":500,\"height\":500},\"i18n_elements\":{\"zh_cn\":[{\"tag\":\"img\",\"url\":\"https://www.feishu.cn\",\"img_key\":\"test\"}]}}}
         */
        private String content;
        /**
         * 自动过期删除的时间戳(秒)
         * <p> 示例值：1739717852
         */
        private String expireTime;
        /**
         * 配置可接收到通知的规则
         * <p> 示例值：
         */
        private Rule rule;

        /**
         * 通知id
         * <p> 示例值：own_xxxxxxxxxxxxxxxx
         *
         * @param notificationId
         * @return
         */
        public Builder notificationId(String notificationId) {
            this.notificationId = notificationId;
            return this;
        }


        /**
         * 通知内容 json 格式
         * <p> 示例值：{\"pc_notification\":{\"config\":{\"width\":500,\"height\":500},\"i18n_elements\":{\"zh_cn\":[{\"tag\":\"img\",\"url\":\"https://www.feishu.cn\",\"img_key\":\"test\"}]}}}
         *
         * @param content
         * @return
         */
        public Builder content(String content) {
            this.content = content;
            return this;
        }


        /**
         * 自动过期删除的时间戳(秒)
         * <p> 示例值：1739717852
         *
         * @param expireTime
         * @return
         */
        public Builder expireTime(String expireTime) {
            this.expireTime = expireTime;
            return this;
        }


        /**
         * 配置可接收到通知的规则
         * <p> 示例值：
         *
         * @param rule
         * @return
         */
        public Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }


        public WorkplaceTenantNotification build() {
            return new WorkplaceTenantNotification(this);
        }
    }
}
