/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.spongycastle.crypto.tls.AbstractTlsPeer;
import org.spongycastle.crypto.tls.DefaultTlsCipherFactory;
import org.spongycastle.crypto.tls.NewSessionTicket;
import org.spongycastle.crypto.tls.ProtocolVersion;
import org.spongycastle.crypto.tls.TlsCipher;
import org.spongycastle.crypto.tls.TlsCipherFactory;
import org.spongycastle.crypto.tls.TlsClient;
import org.spongycastle.crypto.tls.TlsClientContext;
import org.spongycastle.crypto.tls.TlsCompression;
import org.spongycastle.crypto.tls.TlsECCUtils;
import org.spongycastle.crypto.tls.TlsExtensionsUtils;
import org.spongycastle.crypto.tls.TlsFatalAlert;
import org.spongycastle.crypto.tls.TlsNullCompression;
import org.spongycastle.crypto.tls.TlsSession;
import org.spongycastle.crypto.tls.TlsUtils;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsCipherFactory cipherFactory;
    protected TlsClientContext context;
    protected Vector supportedSignatureAlgorithms;
    protected int[] namedCurves;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;

    public AbstractTlsClient() {
        this(new DefaultTlsCipherFactory());
    }

    public AbstractTlsClient(TlsCipherFactory cipherFactory) {
        this.cipherFactory = cipherFactory;
    }

    protected boolean allowUnexpectedServerExtension(Integer extensionType, byte[] extensionData) throws IOException {
        switch (extensionType) {
            case 10: {
                TlsECCUtils.readSupportedEllipticCurvesExtension(extensionData);
                return true;
            }
        }
        return false;
    }

    protected void checkForUnexpectedServerExtension(Hashtable serverExtensions, Integer extensionType) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(serverExtensions, extensionType);
        if (extensionData != null && !this.allowUnexpectedServerExtension(extensionType, extensionData)) {
            throw new TlsFatalAlert(47);
        }
    }

    public void init(TlsClientContext context) {
        this.context = context;
    }

    public TlsSession getSessionToResume() {
        return null;
    }

    public ProtocolVersion getClientHelloRecordLayerVersion() {
        return this.getClientVersion();
    }

    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.TLSv12;
    }

    public boolean isFallback() {
        return false;
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = null;
        ProtocolVersion clientVersion = this.context.getClientVersion();
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion)) {
            this.supportedSignatureAlgorithms = TlsUtils.getDefaultSupportedSignatureAlgorithms();
            clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(clientExtensions);
            TlsUtils.addSignatureAlgorithmsExtension(clientExtensions, this.supportedSignatureAlgorithms);
        }
        if (TlsECCUtils.containsECCCipherSuites(this.getCipherSuites())) {
            this.namedCurves = new int[]{23, 24};
            this.clientECPointFormats = new short[]{0, 1, 2};
            clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(clientExtensions);
            TlsECCUtils.addSupportedEllipticCurvesExtension(clientExtensions, this.namedCurves);
            TlsECCUtils.addSupportedPointFormatsExtension(clientExtensions, this.clientECPointFormats);
        }
        return clientExtensions;
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        if (!this.getMinimumVersion().isEqualOrEarlierVersionOf(serverVersion)) {
            throw new TlsFatalAlert(70);
        }
    }

    public short[] getCompressionMethods() {
        return new short[]{0};
    }

    public void notifySessionID(byte[] sessionID) {
    }

    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (serverExtensions != null) {
            this.checkForUnexpectedServerExtension(serverExtensions, TlsUtils.EXT_signature_algorithms);
            this.checkForUnexpectedServerExtension(serverExtensions, TlsECCUtils.EXT_elliptic_curves);
            if (TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
                this.serverECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(serverExtensions);
            } else {
                this.checkForUnexpectedServerExtension(serverExtensions, TlsECCUtils.EXT_ec_point_formats);
            }
            this.checkForUnexpectedServerExtension(serverExtensions, TlsExtensionsUtils.EXT_padding);
        }
    }

    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        int encryptionAlgorithm = TlsUtils.getEncryptionAlgorithm(this.selectedCipherSuite);
        int macAlgorithm = TlsUtils.getMACAlgorithm(this.selectedCipherSuite);
        return this.cipherFactory.createCipher(this.context, encryptionAlgorithm, macAlgorithm);
    }

    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

