/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import org.spongycastle.crypto.tls.AbstractTlsServer;
import org.spongycastle.crypto.tls.DefaultTlsCipherFactory;
import org.spongycastle.crypto.tls.TlsCipherFactory;
import org.spongycastle.crypto.tls.TlsCredentials;
import org.spongycastle.crypto.tls.TlsFatalAlert;
import org.spongycastle.crypto.tls.TlsKeyExchange;
import org.spongycastle.crypto.tls.TlsSRPIdentityManager;
import org.spongycastle.crypto.tls.TlsSRPKeyExchange;
import org.spongycastle.crypto.tls.TlsSRPLoginParameters;
import org.spongycastle.crypto.tls.TlsSRPUtils;
import org.spongycastle.crypto.tls.TlsSignerCredentials;
import org.spongycastle.crypto.tls.TlsUtils;

public class SRPTlsServer
extends AbstractTlsServer {
    protected TlsSRPIdentityManager srpIdentityManager;
    protected byte[] srpIdentity = null;
    protected TlsSRPLoginParameters loginParameters = null;

    public SRPTlsServer(TlsSRPIdentityManager srpIdentityManager) {
        this(new DefaultTlsCipherFactory(), srpIdentityManager);
    }

    public SRPTlsServer(TlsCipherFactory cipherFactory, TlsSRPIdentityManager srpIdentityManager) {
        super(cipherFactory);
        this.srpIdentityManager = srpIdentityManager;
    }

    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected int[] getCipherSuites() {
        return new int[]{49186, 49183, 49185, 49182, 49184, 49181};
    }

    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        super.processClientExtensions(clientExtensions);
        this.srpIdentity = TlsSRPUtils.getSRPExtension(clientExtensions);
    }

    public int getSelectedCipherSuite() throws IOException {
        int cipherSuite = super.getSelectedCipherSuite();
        if (TlsSRPUtils.isSRPCipherSuite(cipherSuite)) {
            if (this.srpIdentity != null) {
                this.loginParameters = this.srpIdentityManager.getLoginParameters(this.srpIdentity);
            }
            if (this.loginParameters == null) {
                throw new TlsFatalAlert(115);
            }
        }
        return cipherSuite;
    }

    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 21: {
                return null;
            }
            case 22: {
                return this.getDSASignerCredentials();
            }
            case 23: {
                return this.getRSASignerCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int keyExchange) {
        return new TlsSRPKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.srpIdentity, this.loginParameters);
    }
}

