/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.enums.Duration;
import com.mailgun.enums.ResolutionPeriod;
import com.mailgun.enums.StatsEventType;
import com.mailgun.util.CollectionUtil;
import com.mailgun.util.DateTimeUtil;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

@JsonDeserialize(builder=StatisticsOptionsBuilder.class)
public final class StatisticsOptions {
    @NonNull
    private final Set<String> event;
    private final String start;
    private final String end;
    private final String resolution;
    private final String duration;

    public static StatisticsOptionsBuilder builder() {
        return new StatisticsOptionsBuilder();
    }

    @NonNull
    public Set<String> getEvent() {
        return this.event;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getDuration() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticsOptions)) {
            return false;
        }
        StatisticsOptions other = (StatisticsOptions)o;
        Set<String> this$event = this.getEvent();
        Set<String> other$event = other.getEvent();
        if (this$event == null ? other$event != null : !((Object)this$event).equals(other$event)) {
            return false;
        }
        String this$start = this.getStart();
        String other$start = other.getStart();
        if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
            return false;
        }
        String this$end = this.getEnd();
        String other$end = other.getEnd();
        if (this$end == null ? other$end != null : !this$end.equals(other$end)) {
            return false;
        }
        String this$resolution = this.getResolution();
        String other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        return !(this$duration == null ? other$duration != null : !this$duration.equals(other$duration));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
        String $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : $start.hashCode());
        String $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : $end.hashCode());
        String $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : $resolution.hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        return result;
    }

    public String toString() {
        return "StatisticsOptions(event=" + this.getEvent() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", resolution=" + this.getResolution() + ", duration=" + this.getDuration() + ")";
    }

    public StatisticsOptions(@NonNull Set<String> event, String start, String end, String resolution, String duration) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
        this.start = start;
        this.end = end;
        this.resolution = resolution;
        this.duration = duration;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class StatisticsOptionsBuilder {
        private Set<String> event;
        private String start;
        private String end;
        private String resolution;
        private String duration;

        public StatisticsOptionsBuilder event(StatsEventType event) {
            this.event = CollectionUtil.addToSet(this.event, event.getValue());
            return this;
        }

        public StatisticsOptionsBuilder event(List<StatsEventType> events) {
            this.event = CollectionUtil.addToSet(this.event, events.stream().map(StatsEventType::getValue).collect(Collectors.toList()));
            return this;
        }

        public StatisticsOptionsBuilder start(ZonedDateTime zonedDateTime) {
            this.start = DateTimeUtil.toStringNumericTimeZone(zonedDateTime);
            return this;
        }

        public StatisticsOptionsBuilder end(ZonedDateTime zonedDateTime) {
            this.end = DateTimeUtil.toStringNumericTimeZone(zonedDateTime);
            return this;
        }

        public StatisticsOptionsBuilder resolution(ResolutionPeriod resolutionPeriod) {
            this.resolution = resolutionPeriod.getValue();
            return this;
        }

        public StatisticsOptionsBuilder duration(int timeValue, Duration duration) {
            Validate.isTrue((timeValue > 0 ? 1 : 0) != 0, (String)"Duration' must be greater than zero: %d", (long)timeValue);
            String durationValue = duration.getValue();
            this.duration = timeValue + durationValue;
            return this;
        }

        StatisticsOptionsBuilder() {
        }

        public StatisticsOptions build() {
            return new StatisticsOptions(this.event, this.start, this.end, this.resolution, this.duration);
        }

        public String toString() {
            return "StatisticsOptions.StatisticsOptionsBuilder(event=" + this.event + ", start=" + this.start + ", end=" + this.end + ", resolution=" + this.resolution + ", duration=" + this.duration + ")";
        }
    }
}

