/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.api.v3;

import com.mailgun.api.MailgunApi;
import com.mailgun.model.PagingWithPivot;
import com.mailgun.model.ResponseWithMessage;
import com.mailgun.model.templates.TemplateAllVersionsResponse;
import com.mailgun.model.templates.TemplateRequest;
import com.mailgun.model.templates.TemplateResponse;
import com.mailgun.model.templates.TemplateStatusResponse;
import com.mailgun.model.templates.TemplateVersionRequest;
import com.mailgun.model.templates.TemplateVersionResponse;
import com.mailgun.model.templates.TemplateWithMessageResponse;
import com.mailgun.model.templates.TemplateWithVersionResponse;
import com.mailgun.model.templates.TemplatesResult;
import com.mailgun.model.templates.UpdateTemplateVersionRequest;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.Response;

@Headers(value={"Accept: application/json"})
public interface MailgunTemplatesApi
extends MailgunApi {
    @RequestLine(value="GET /{domain}/templates")
    public TemplatesResult getAllTemplates(@Param(value="domain") String var1);

    @RequestLine(value="GET /{domain}/templates")
    public Response getAllTemplatesFeignResponse(@Param(value="domain") String var1);

    @RequestLine(value="GET /{domain}/templates")
    public TemplatesResult getAllTemplates(@Param(value="domain") String var1, @QueryMap PagingWithPivot var2);

    @RequestLine(value="GET /{domain}/templates")
    public Response getAllTemplatesFeignResponse(@Param(value="domain") String var1, @QueryMap PagingWithPivot var2);

    @RequestLine(value="GET /{domain}/templates/{name}")
    public TemplateResponse getTemplate(@Param(value="domain") String var1, @Param(value="name") String var2);

    @RequestLine(value="GET /{domain}/templates/{name}")
    public Response getTemplateFeignResponse(@Param(value="domain") String var1, @Param(value="name") String var2);

    @RequestLine(value="GET /{domain}/templates/{name}?active=yes")
    public TemplateWithVersionResponse getActiveTemplateVersionContent(@Param(value="domain") String var1, @Param(value="name") String var2);

    @RequestLine(value="GET /{domain}/templates/{name}?active=yes")
    public Response getActiveTemplateVersionContentFeignResponse(@Param(value="domain") String var1, @Param(value="name") String var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="POST /{domain}/templates")
    public TemplateWithMessageResponse storeNewTemplate(@Param(value="domain") String var1, TemplateRequest var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="POST /{domain}/templates")
    public Response storeNewTemplateFeignResponse(@Param(value="domain") String var1, TemplateRequest var2);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /{domain}/templates/{name}")
    public TemplateStatusResponse updateTemplate(@Param(value="domain") String var1, @Param(value="name") String var2, @Param(value="description") String var3);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /{domain}/templates/{name}")
    public Response updateTemplateFeignResponse(@Param(value="domain") String var1, @Param(value="name") String var2, @Param(value="description") String var3);

    @RequestLine(value="DELETE /{domain}/templates/{name}")
    public TemplateStatusResponse deleteTemplate(@Param(value="domain") String var1, @Param(value="name") String var2);

    @RequestLine(value="DELETE /{domain}/templates/{name}")
    public Response deleteTemplateFeignResponse(@Param(value="domain") String var1, @Param(value="name") String var2);

    @RequestLine(value="DELETE /{domain}/templates")
    public ResponseWithMessage deleteAllTemplatesInDomain(@Param(value="domain") String var1);

    @RequestLine(value="DELETE /{domain}/templates")
    public Response deleteAllTemplatesInDomainFeignResponse(@Param(value="domain") String var1);

    @RequestLine(value="GET /{domain}/templates/{templateName}/versions")
    public TemplateAllVersionsResponse getAllTemplateVersions(@Param(value="domain") String var1, @Param(value="templateName") String var2);

    @RequestLine(value="GET /{domain}/templates/{templateName}/versions")
    public Response getAllTemplateVersionsFeignResponse(@Param(value="domain") String var1, @Param(value="templateName") String var2);

    @RequestLine(value="GET /{domain}/templates/{templateName}/versions")
    public TemplateAllVersionsResponse getAllTemplateVersions(@Param(value="domain") String var1, @Param(value="templateName") String var2, @QueryMap PagingWithPivot var3);

    @RequestLine(value="GET /{domain}/templates/{templateName}/versions")
    public Response getAllTemplateVersionsFeignResponse(@Param(value="domain") String var1, @Param(value="templateName") String var2, @QueryMap PagingWithPivot var3);

    @RequestLine(value="GET /{domain}/templates/{templateName}/versions/{tag}")
    public TemplateWithVersionResponse getSpecifiedVersionTemplateContent(@Param(value="domain") String var1, @Param(value="templateName") String var2, @Param(value="tag") String var3);

    @RequestLine(value="GET /{domain}/templates/{templateName}/versions/{tag}")
    public Response getSpecifiedVersionTemplateContentFeignResponse(@Param(value="domain") String var1, @Param(value="templateName") String var2, @Param(value="tag") String var3);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="POST /{domain}/templates/{templateName}/versions")
    public TemplateWithMessageResponse createNewTemplateVersion(@Param(value="domain") String var1, @Param(value="templateName") String var2, TemplateVersionRequest var3);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="POST /{domain}/templates/{templateName}/versions")
    public Response createNewTemplateVersionFeignResponse(@Param(value="domain") String var1, @Param(value="templateName") String var2, TemplateVersionRequest var3);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /{domain}/templates/{templateName}/versions/{tag}")
    public TemplateVersionResponse updateSpecificTemplateVersion(@Param(value="domain") String var1, @Param(value="templateName") String var2, @Param(value="tag") String var3, UpdateTemplateVersionRequest var4);

    @Headers(value={"Content-Type: multipart/form-data"})
    @RequestLine(value="PUT /{domain}/templates/{templateName}/versions/{tag}")
    public Response updateSpecificTemplateVersionFeignResponse(@Param(value="domain") String var1, @Param(value="templateName") String var2, @Param(value="tag") String var3, UpdateTemplateVersionRequest var4);

    @RequestLine(value="DELETE /{domain}/templates/{templateName}/versions/{templateVersion}")
    public TemplateVersionResponse deleteSpecificTemplateVersion(@Param(value="domain") String var1, @Param(value="templateName") String var2, @Param(value="templateVersion") String var3);

    @RequestLine(value="DELETE /{domain}/templates/{templateName}/versions/{templateVersion}")
    public Response deleteSpecificTemplateVersionFeignResponse(@Param(value="domain") String var1, @Param(value="templateName") String var2, @Param(value="templateVersion") String var3);
}

