/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.domains;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.enums.DomainState;
import com.mailgun.enums.SpamAction;
import com.mailgun.enums.WebScheme;
import java.time.ZonedDateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=DomainBuilder.class)
public final class Domain {
    private final String id;
    @JsonProperty(value="is_disabled")
    private final Boolean isDisabled;
    private final String name;
    @JsonProperty(value="require_tls")
    private final Boolean requireTls;
    @JsonProperty(value="skip_verification")
    private final Boolean skipVerification;
    @JsonProperty(value="smtp_login")
    private final String smtpLogin;
    @JsonProperty(value="spam_action")
    private final SpamAction spamAction;
    private final DomainState state;
    private final String type;
    @JsonProperty(value="web_prefix")
    private final String webPrefix;
    @JsonProperty(value="web_scheme")
    private final WebScheme webScheme;
    private final Boolean wildcard;
    @JsonFormat(pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
    @JsonProperty(value="created_at")
    private final ZonedDateTime createdAt;

    Domain(String id, Boolean isDisabled, String name, Boolean requireTls, Boolean skipVerification, String smtpLogin, SpamAction spamAction, DomainState state, String type, String webPrefix, WebScheme webScheme, Boolean wildcard, ZonedDateTime createdAt) {
        this.id = id;
        this.isDisabled = isDisabled;
        this.name = name;
        this.requireTls = requireTls;
        this.skipVerification = skipVerification;
        this.smtpLogin = smtpLogin;
        this.spamAction = spamAction;
        this.state = state;
        this.type = type;
        this.webPrefix = webPrefix;
        this.webScheme = webScheme;
        this.wildcard = wildcard;
        this.createdAt = createdAt;
    }

    public static DomainBuilder builder() {
        return new DomainBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getRequireTls() {
        return this.requireTls;
    }

    public Boolean getSkipVerification() {
        return this.skipVerification;
    }

    public String getSmtpLogin() {
        return this.smtpLogin;
    }

    public SpamAction getSpamAction() {
        return this.spamAction;
    }

    public DomainState getState() {
        return this.state;
    }

    public String getType() {
        return this.type;
    }

    public String getWebPrefix() {
        return this.webPrefix;
    }

    public WebScheme getWebScheme() {
        return this.webScheme;
    }

    public Boolean getWildcard() {
        return this.wildcard;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Domain)) {
            return false;
        }
        Domain other = (Domain)o;
        Boolean this$isDisabled = this.getIsDisabled();
        Boolean other$isDisabled = other.getIsDisabled();
        if (this$isDisabled == null ? other$isDisabled != null : !((Object)this$isDisabled).equals(other$isDisabled)) {
            return false;
        }
        Boolean this$requireTls = this.getRequireTls();
        Boolean other$requireTls = other.getRequireTls();
        if (this$requireTls == null ? other$requireTls != null : !((Object)this$requireTls).equals(other$requireTls)) {
            return false;
        }
        Boolean this$skipVerification = this.getSkipVerification();
        Boolean other$skipVerification = other.getSkipVerification();
        if (this$skipVerification == null ? other$skipVerification != null : !((Object)this$skipVerification).equals(other$skipVerification)) {
            return false;
        }
        Boolean this$wildcard = this.getWildcard();
        Boolean other$wildcard = other.getWildcard();
        if (this$wildcard == null ? other$wildcard != null : !((Object)this$wildcard).equals(other$wildcard)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$smtpLogin = this.getSmtpLogin();
        String other$smtpLogin = other.getSmtpLogin();
        if (this$smtpLogin == null ? other$smtpLogin != null : !this$smtpLogin.equals(other$smtpLogin)) {
            return false;
        }
        SpamAction this$spamAction = this.getSpamAction();
        SpamAction other$spamAction = other.getSpamAction();
        if (this$spamAction == null ? other$spamAction != null : !((Object)((Object)this$spamAction)).equals((Object)other$spamAction)) {
            return false;
        }
        DomainState this$state = this.getState();
        DomainState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$webPrefix = this.getWebPrefix();
        String other$webPrefix = other.getWebPrefix();
        if (this$webPrefix == null ? other$webPrefix != null : !this$webPrefix.equals(other$webPrefix)) {
            return false;
        }
        WebScheme this$webScheme = this.getWebScheme();
        WebScheme other$webScheme = other.getWebScheme();
        if (this$webScheme == null ? other$webScheme != null : !((Object)((Object)this$webScheme)).equals((Object)other$webScheme)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDisabled = this.getIsDisabled();
        result = result * 59 + ($isDisabled == null ? 43 : ((Object)$isDisabled).hashCode());
        Boolean $requireTls = this.getRequireTls();
        result = result * 59 + ($requireTls == null ? 43 : ((Object)$requireTls).hashCode());
        Boolean $skipVerification = this.getSkipVerification();
        result = result * 59 + ($skipVerification == null ? 43 : ((Object)$skipVerification).hashCode());
        Boolean $wildcard = this.getWildcard();
        result = result * 59 + ($wildcard == null ? 43 : ((Object)$wildcard).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $smtpLogin = this.getSmtpLogin();
        result = result * 59 + ($smtpLogin == null ? 43 : $smtpLogin.hashCode());
        SpamAction $spamAction = this.getSpamAction();
        result = result * 59 + ($spamAction == null ? 43 : ((Object)((Object)$spamAction)).hashCode());
        DomainState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $webPrefix = this.getWebPrefix();
        result = result * 59 + ($webPrefix == null ? 43 : $webPrefix.hashCode());
        WebScheme $webScheme = this.getWebScheme();
        result = result * 59 + ($webScheme == null ? 43 : ((Object)((Object)$webScheme)).hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "Domain(id=" + this.getId() + ", isDisabled=" + this.getIsDisabled() + ", name=" + this.getName() + ", requireTls=" + this.getRequireTls() + ", skipVerification=" + this.getSkipVerification() + ", smtpLogin=" + this.getSmtpLogin() + ", spamAction=" + (Object)((Object)this.getSpamAction()) + ", state=" + (Object)((Object)this.getState()) + ", type=" + this.getType() + ", webPrefix=" + this.getWebPrefix() + ", webScheme=" + (Object)((Object)this.getWebScheme()) + ", wildcard=" + this.getWildcard() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class DomainBuilder {
        private String id;
        private Boolean isDisabled;
        private String name;
        private Boolean requireTls;
        private Boolean skipVerification;
        private String smtpLogin;
        private SpamAction spamAction;
        private DomainState state;
        private String type;
        private String webPrefix;
        private WebScheme webScheme;
        private Boolean wildcard;
        private ZonedDateTime createdAt;

        DomainBuilder() {
        }

        public DomainBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="is_disabled")
        public DomainBuilder isDisabled(Boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public DomainBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="require_tls")
        public DomainBuilder requireTls(Boolean requireTls) {
            this.requireTls = requireTls;
            return this;
        }

        @JsonProperty(value="skip_verification")
        public DomainBuilder skipVerification(Boolean skipVerification) {
            this.skipVerification = skipVerification;
            return this;
        }

        @JsonProperty(value="smtp_login")
        public DomainBuilder smtpLogin(String smtpLogin) {
            this.smtpLogin = smtpLogin;
            return this;
        }

        @JsonProperty(value="spam_action")
        public DomainBuilder spamAction(SpamAction spamAction) {
            this.spamAction = spamAction;
            return this;
        }

        public DomainBuilder state(DomainState state) {
            this.state = state;
            return this;
        }

        public DomainBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="web_prefix")
        public DomainBuilder webPrefix(String webPrefix) {
            this.webPrefix = webPrefix;
            return this;
        }

        @JsonProperty(value="web_scheme")
        public DomainBuilder webScheme(WebScheme webScheme) {
            this.webScheme = webScheme;
            return this;
        }

        public DomainBuilder wildcard(Boolean wildcard) {
            this.wildcard = wildcard;
            return this;
        }

        @JsonFormat(pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
        @JsonProperty(value="created_at")
        public DomainBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Domain build() {
            return new Domain(this.id, this.isDisabled, this.name, this.requireTls, this.skipVerification, this.smtpLogin, this.spamAction, this.state, this.type, this.webPrefix, this.webScheme, this.wildcard, this.createdAt);
        }

        public String toString() {
            return "Domain.DomainBuilder(id=" + this.id + ", isDisabled=" + this.isDisabled + ", name=" + this.name + ", requireTls=" + this.requireTls + ", skipVerification=" + this.skipVerification + ", smtpLogin=" + this.smtpLogin + ", spamAction=" + (Object)((Object)this.spamAction) + ", state=" + (Object)((Object)this.state) + ", type=" + this.type + ", webPrefix=" + this.webPrefix + ", webScheme=" + (Object)((Object)this.webScheme) + ", wildcard=" + this.wildcard + ", createdAt=" + this.createdAt + ")";
        }
    }
}

