/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.domains;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.model.domains.Domain;
import com.mailgun.model.domains.ReceivingDnsRecords;
import com.mailgun.model.domains.SendingDnsRecord;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=DomainResponseBuilder.class)
public final class DomainResponse {
    private final Domain domain;
    private final String message;
    @JsonProperty(value="receiving_dns_records")
    private final List<ReceivingDnsRecords> receivingDnsRecords;
    @JsonProperty(value="sending_dns_records")
    private final List<SendingDnsRecord> sendingDnsRecords;

    DomainResponse(Domain domain, String message, List<ReceivingDnsRecords> receivingDnsRecords, List<SendingDnsRecord> sendingDnsRecords) {
        this.domain = domain;
        this.message = message;
        this.receivingDnsRecords = receivingDnsRecords;
        this.sendingDnsRecords = sendingDnsRecords;
    }

    public static DomainResponseBuilder builder() {
        return new DomainResponseBuilder();
    }

    public Domain getDomain() {
        return this.domain;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ReceivingDnsRecords> getReceivingDnsRecords() {
        return this.receivingDnsRecords;
    }

    public List<SendingDnsRecord> getSendingDnsRecords() {
        return this.sendingDnsRecords;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomainResponse)) {
            return false;
        }
        DomainResponse other = (DomainResponse)o;
        Domain this$domain = this.getDomain();
        Domain other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !((Object)this$domain).equals(other$domain)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<ReceivingDnsRecords> this$receivingDnsRecords = this.getReceivingDnsRecords();
        List<ReceivingDnsRecords> other$receivingDnsRecords = other.getReceivingDnsRecords();
        if (this$receivingDnsRecords == null ? other$receivingDnsRecords != null : !((Object)this$receivingDnsRecords).equals(other$receivingDnsRecords)) {
            return false;
        }
        List<SendingDnsRecord> this$sendingDnsRecords = this.getSendingDnsRecords();
        List<SendingDnsRecord> other$sendingDnsRecords = other.getSendingDnsRecords();
        return !(this$sendingDnsRecords == null ? other$sendingDnsRecords != null : !((Object)this$sendingDnsRecords).equals(other$sendingDnsRecords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Domain $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : ((Object)$domain).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<ReceivingDnsRecords> $receivingDnsRecords = this.getReceivingDnsRecords();
        result = result * 59 + ($receivingDnsRecords == null ? 43 : ((Object)$receivingDnsRecords).hashCode());
        List<SendingDnsRecord> $sendingDnsRecords = this.getSendingDnsRecords();
        result = result * 59 + ($sendingDnsRecords == null ? 43 : ((Object)$sendingDnsRecords).hashCode());
        return result;
    }

    public String toString() {
        return "DomainResponse(domain=" + this.getDomain() + ", message=" + this.getMessage() + ", receivingDnsRecords=" + this.getReceivingDnsRecords() + ", sendingDnsRecords=" + this.getSendingDnsRecords() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class DomainResponseBuilder {
        private Domain domain;
        private String message;
        private List<ReceivingDnsRecords> receivingDnsRecords;
        private List<SendingDnsRecord> sendingDnsRecords;

        DomainResponseBuilder() {
        }

        public DomainResponseBuilder domain(Domain domain) {
            this.domain = domain;
            return this;
        }

        public DomainResponseBuilder message(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="receiving_dns_records")
        public DomainResponseBuilder receivingDnsRecords(List<ReceivingDnsRecords> receivingDnsRecords) {
            this.receivingDnsRecords = receivingDnsRecords;
            return this;
        }

        @JsonProperty(value="sending_dns_records")
        public DomainResponseBuilder sendingDnsRecords(List<SendingDnsRecord> sendingDnsRecords) {
            this.sendingDnsRecords = sendingDnsRecords;
            return this;
        }

        public DomainResponse build() {
            return new DomainResponse(this.domain, this.message, this.receivingDnsRecords, this.sendingDnsRecords);
        }

        public String toString() {
            return "DomainResponse.DomainResponseBuilder(domain=" + this.domain + ", message=" + this.message + ", receivingDnsRecords=" + this.receivingDnsRecords + ", sendingDnsRecords=" + this.sendingDnsRecords + ")";
        }
    }
}

