/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.model.events.EventMessageAttachment;
import com.mailgun.model.events.EventMessageHeaders;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=EventMessageBuilder.class)
public final class EventMessage {
    private final EventMessageHeaders headers;
    private final List<EventMessageAttachment> attachments;
    private final List<String> recipients;
    private final Integer size;

    EventMessage(EventMessageHeaders headers, List<EventMessageAttachment> attachments, List<String> recipients, Integer size) {
        this.headers = headers;
        this.attachments = attachments;
        this.recipients = recipients;
        this.size = size;
    }

    public static EventMessageBuilder builder() {
        return new EventMessageBuilder();
    }

    public EventMessageHeaders getHeaders() {
        return this.headers;
    }

    public List<EventMessageAttachment> getAttachments() {
        return this.attachments;
    }

    public List<String> getRecipients() {
        return this.recipients;
    }

    public Integer getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventMessage)) {
            return false;
        }
        EventMessage other = (EventMessage)o;
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        EventMessageHeaders this$headers = this.getHeaders();
        EventMessageHeaders other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<EventMessageAttachment> this$attachments = this.getAttachments();
        List<EventMessageAttachment> other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        List<String> this$recipients = this.getRecipients();
        List<String> other$recipients = other.getRecipients();
        return !(this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        EventMessageHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<EventMessageAttachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        List<String> $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        return result;
    }

    public String toString() {
        return "EventMessage(headers=" + this.getHeaders() + ", attachments=" + this.getAttachments() + ", recipients=" + this.getRecipients() + ", size=" + this.getSize() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class EventMessageBuilder {
        private EventMessageHeaders headers;
        private List<EventMessageAttachment> attachments;
        private List<String> recipients;
        private Integer size;

        EventMessageBuilder() {
        }

        public EventMessageBuilder headers(EventMessageHeaders headers) {
            this.headers = headers;
            return this;
        }

        public EventMessageBuilder attachments(List<EventMessageAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public EventMessageBuilder recipients(List<String> recipients) {
            this.recipients = recipients;
            return this;
        }

        public EventMessageBuilder size(Integer size) {
            this.size = size;
            return this;
        }

        public EventMessage build() {
            return new EventMessage(this.headers, this.attachments, this.recipients, this.size);
        }

        public String toString() {
            return "EventMessage.EventMessageBuilder(headers=" + this.headers + ", attachments=" + this.attachments + ", recipients=" + this.recipients + ", size=" + this.size + ")";
        }
    }
}

