/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.events;

import com.mailgun.enums.EventType;
import com.mailgun.enums.Severity;
import com.mailgun.enums.YesNo;
import feign.Param;
import java.time.ZonedDateTime;

public class EventsQueryOptions {
    Long begin;
    Long end;
    String ascending;
    Integer limit;
    String event;
    String attachment;
    String from;
    @Param(value="message-id")
    String messageId;
    String subject;
    String to;
    String size;
    String recipient;
    String recipients;
    String tags;
    String severity;

    EventsQueryOptions(Long begin, Long end, String ascending, Integer limit, String event, String attachment, String from, String messageId, String subject, String to, String size, String recipient, String recipients, String tags, String severity) {
        this.begin = begin;
        this.end = end;
        this.ascending = ascending;
        this.limit = limit;
        this.event = event;
        this.attachment = attachment;
        this.from = from;
        this.messageId = messageId;
        this.subject = subject;
        this.to = to;
        this.size = size;
        this.recipient = recipient;
        this.recipients = recipients;
        this.tags = tags;
        this.severity = severity;
    }

    public static EventsQueryOptionsBuilder builder() {
        return new EventsQueryOptionsBuilder();
    }

    public Long getBegin() {
        return this.begin;
    }

    public Long getEnd() {
        return this.end;
    }

    public String getAscending() {
        return this.ascending;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getEvent() {
        return this.event;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public String getFrom() {
        return this.from;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTo() {
        return this.to;
    }

    public String getSize() {
        return this.size;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public String getTags() {
        return this.tags;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String toString() {
        return "EventsQueryOptions(begin=" + this.getBegin() + ", end=" + this.getEnd() + ", ascending=" + this.getAscending() + ", limit=" + this.getLimit() + ", event=" + this.getEvent() + ", attachment=" + this.getAttachment() + ", from=" + this.getFrom() + ", messageId=" + this.getMessageId() + ", subject=" + this.getSubject() + ", to=" + this.getTo() + ", size=" + this.getSize() + ", recipient=" + this.getRecipient() + ", recipients=" + this.getRecipients() + ", tags=" + this.getTags() + ", severity=" + this.getSeverity() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventsQueryOptions)) {
            return false;
        }
        EventsQueryOptions other = (EventsQueryOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$begin = this.getBegin();
        Long other$begin = other.getBegin();
        if (this$begin == null ? other$begin != null : !((Object)this$begin).equals(other$begin)) {
            return false;
        }
        Long this$end = this.getEnd();
        Long other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$ascending = this.getAscending();
        String other$ascending = other.getAscending();
        if (this$ascending == null ? other$ascending != null : !this$ascending.equals(other$ascending)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$attachment = this.getAttachment();
        String other$attachment = other.getAttachment();
        if (this$attachment == null ? other$attachment != null : !this$attachment.equals(other$attachment)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$recipient = this.getRecipient();
        String other$recipient = other.getRecipient();
        if (this$recipient == null ? other$recipient != null : !this$recipient.equals(other$recipient)) {
            return false;
        }
        String this$recipients = this.getRecipients();
        String other$recipients = other.getRecipients();
        if (this$recipients == null ? other$recipients != null : !this$recipients.equals(other$recipients)) {
            return false;
        }
        String this$tags = this.getTags();
        String other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        return !(this$severity == null ? other$severity != null : !this$severity.equals(other$severity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventsQueryOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $begin = this.getBegin();
        result = result * 59 + ($begin == null ? 43 : ((Object)$begin).hashCode());
        Long $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $ascending = this.getAscending();
        result = result * 59 + ($ascending == null ? 43 : $ascending.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $attachment = this.getAttachment();
        result = result * 59 + ($attachment == null ? 43 : $attachment.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $recipient = this.getRecipient();
        result = result * 59 + ($recipient == null ? 43 : $recipient.hashCode());
        String $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : $recipients.hashCode());
        String $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        return result;
    }

    public static class EventsQueryOptionsBuilder {
        private Long begin;
        private Long end;
        private String ascending;
        private Integer limit;
        private String event;
        private String attachment;
        private String from;
        private String messageId;
        private String subject;
        private String to;
        private String size;
        private String recipient;
        private String recipients;
        private String tags;
        private String severity;

        public EventsQueryOptionsBuilder begin(ZonedDateTime time) {
            this.begin = time.toEpochSecond();
            return this;
        }

        public EventsQueryOptionsBuilder begin(Long time) {
            this.begin = time;
            return this;
        }

        public EventsQueryOptionsBuilder end(ZonedDateTime time) {
            this.end = time.toEpochSecond();
            return this;
        }

        public EventsQueryOptionsBuilder end(Long time) {
            this.end = time;
            return this;
        }

        public EventsQueryOptionsBuilder ascending(boolean ascending) {
            this.ascending = YesNo.getValue(ascending);
            return this;
        }

        public EventsQueryOptionsBuilder event(EventType event) {
            this.event = event.getValue();
            return this;
        }

        public EventsQueryOptionsBuilder eventFieldFilterExpression(String filterExpression) {
            this.event = filterExpression;
            return this;
        }

        public EventsQueryOptionsBuilder severity(Severity severity) {
            this.severity = severity.getValue();
            return this;
        }

        public EventsQueryOptionsBuilder attachment(String filterExpression) {
            this.attachment = filterExpression;
            return this;
        }

        public EventsQueryOptionsBuilder from(String filterExpression) {
            this.from = filterExpression;
            return this;
        }

        public EventsQueryOptionsBuilder messageId(String filterExpression) {
            this.messageId = filterExpression;
            return this;
        }

        public EventsQueryOptionsBuilder subject(String filterExpression) {
            this.subject = filterExpression;
            return this;
        }

        public EventsQueryOptionsBuilder to(String filterExpression) {
            this.to = filterExpression;
            return this;
        }

        public EventsQueryOptionsBuilder size(String filterExpression) {
            this.size = filterExpression;
            return this;
        }

        public EventsQueryOptionsBuilder recipient(String filterExpression) {
            this.recipient = filterExpression;
            return this;
        }

        public EventsQueryOptionsBuilder recipients(String filterExpression) {
            this.recipients = filterExpression;
            return this;
        }

        public EventsQueryOptionsBuilder tags(String filterExpression) {
            this.tags = filterExpression;
            return this;
        }

        EventsQueryOptionsBuilder() {
        }

        public EventsQueryOptionsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public EventsQueryOptions build() {
            return new EventsQueryOptions(this.begin, this.end, this.ascending, this.limit, this.event, this.attachment, this.from, this.messageId, this.subject, this.to, this.size, this.recipient, this.recipients, this.tags, this.severity);
        }

        public String toString() {
            return "EventsQueryOptions.EventsQueryOptionsBuilder(begin=" + this.begin + ", end=" + this.end + ", ascending=" + this.ascending + ", limit=" + this.limit + ", event=" + this.event + ", attachment=" + this.attachment + ", from=" + this.from + ", messageId=" + this.messageId + ", subject=" + this.subject + ", to=" + this.to + ", size=" + this.size + ", recipient=" + this.recipient + ", recipients=" + this.recipients + ", tags=" + this.tags + ", severity=" + this.severity + ")";
        }
    }
}

