/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.mailing.lists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.enums.YesNo;

@JsonDeserialize(builder=MailingListMembersRequestBuilder.class)
public final class MailingListMembersRequest {
    private final Integer limit;
    private final String page;
    private final String address;
    private final String subscribed;

    MailingListMembersRequest(Integer limit, String page, String address, String subscribed) {
        this.limit = limit;
        this.page = page;
        this.address = address;
        this.subscribed = subscribed;
    }

    public static MailingListMembersRequestBuilder builder() {
        return new MailingListMembersRequestBuilder();
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getAddress() {
        return this.address;
    }

    public String getSubscribed() {
        return this.subscribed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailingListMembersRequest)) {
            return false;
        }
        MailingListMembersRequest other = (MailingListMembersRequest)o;
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$subscribed = this.getSubscribed();
        String other$subscribed = other.getSubscribed();
        return !(this$subscribed == null ? other$subscribed != null : !this$subscribed.equals(other$subscribed));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $subscribed = this.getSubscribed();
        result = result * 59 + ($subscribed == null ? 43 : $subscribed.hashCode());
        return result;
    }

    public String toString() {
        return "MailingListMembersRequest(limit=" + this.getLimit() + ", page=" + this.getPage() + ", address=" + this.getAddress() + ", subscribed=" + this.getSubscribed() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MailingListMembersRequestBuilder {
        private Integer limit;
        private String page;
        private String address;
        private String subscribed;

        public MailingListMembersRequestBuilder subscribed(boolean subscribed) {
            this.subscribed = YesNo.getValue(subscribed);
            return this;
        }

        MailingListMembersRequestBuilder() {
        }

        public MailingListMembersRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public MailingListMembersRequestBuilder page(String page) {
            this.page = page;
            return this;
        }

        public MailingListMembersRequestBuilder address(String address) {
            this.address = address;
            return this;
        }

        public MailingListMembersRequest build() {
            return new MailingListMembersRequest(this.limit, this.page, this.address, this.subscribed);
        }

        public String toString() {
            return "MailingListMembersRequest.MailingListMembersRequestBuilder(limit=" + this.limit + ", page=" + this.page + ", address=" + this.address + ", subscribed=" + this.subscribed + ")";
        }
    }
}

