/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.stats;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.mailgun.model.stats.Accepted;
import com.mailgun.model.stats.Delivered;
import com.mailgun.model.stats.Failed;
import com.mailgun.model.stats.StatsTotalValueObject;
import java.time.ZonedDateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=StatsBuilder.class)
public final class Stats {
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
    private final ZonedDateTime time;
    private final Accepted accepted;
    private final Delivered delivered;
    private final Failed failed;
    private final StatsTotalValueObject stored;
    private final StatsTotalValueObject opened;
    private final StatsTotalValueObject clicked;
    private final StatsTotalValueObject unsubscribed;
    private final StatsTotalValueObject complained;

    Stats(ZonedDateTime time, Accepted accepted, Delivered delivered, Failed failed, StatsTotalValueObject stored, StatsTotalValueObject opened, StatsTotalValueObject clicked, StatsTotalValueObject unsubscribed, StatsTotalValueObject complained) {
        this.time = time;
        this.accepted = accepted;
        this.delivered = delivered;
        this.failed = failed;
        this.stored = stored;
        this.opened = opened;
        this.clicked = clicked;
        this.unsubscribed = unsubscribed;
        this.complained = complained;
    }

    public static StatsBuilder builder() {
        return new StatsBuilder();
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public Accepted getAccepted() {
        return this.accepted;
    }

    public Delivered getDelivered() {
        return this.delivered;
    }

    public Failed getFailed() {
        return this.failed;
    }

    public StatsTotalValueObject getStored() {
        return this.stored;
    }

    public StatsTotalValueObject getOpened() {
        return this.opened;
    }

    public StatsTotalValueObject getClicked() {
        return this.clicked;
    }

    public StatsTotalValueObject getUnsubscribed() {
        return this.unsubscribed;
    }

    public StatsTotalValueObject getComplained() {
        return this.complained;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Stats)) {
            return false;
        }
        Stats other = (Stats)o;
        ZonedDateTime this$time = this.getTime();
        ZonedDateTime other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Accepted this$accepted = this.getAccepted();
        Accepted other$accepted = other.getAccepted();
        if (this$accepted == null ? other$accepted != null : !((Object)this$accepted).equals(other$accepted)) {
            return false;
        }
        Delivered this$delivered = this.getDelivered();
        Delivered other$delivered = other.getDelivered();
        if (this$delivered == null ? other$delivered != null : !((Object)this$delivered).equals(other$delivered)) {
            return false;
        }
        Failed this$failed = this.getFailed();
        Failed other$failed = other.getFailed();
        if (this$failed == null ? other$failed != null : !((Object)this$failed).equals(other$failed)) {
            return false;
        }
        StatsTotalValueObject this$stored = this.getStored();
        StatsTotalValueObject other$stored = other.getStored();
        if (this$stored == null ? other$stored != null : !((Object)this$stored).equals(other$stored)) {
            return false;
        }
        StatsTotalValueObject this$opened = this.getOpened();
        StatsTotalValueObject other$opened = other.getOpened();
        if (this$opened == null ? other$opened != null : !((Object)this$opened).equals(other$opened)) {
            return false;
        }
        StatsTotalValueObject this$clicked = this.getClicked();
        StatsTotalValueObject other$clicked = other.getClicked();
        if (this$clicked == null ? other$clicked != null : !((Object)this$clicked).equals(other$clicked)) {
            return false;
        }
        StatsTotalValueObject this$unsubscribed = this.getUnsubscribed();
        StatsTotalValueObject other$unsubscribed = other.getUnsubscribed();
        if (this$unsubscribed == null ? other$unsubscribed != null : !((Object)this$unsubscribed).equals(other$unsubscribed)) {
            return false;
        }
        StatsTotalValueObject this$complained = this.getComplained();
        StatsTotalValueObject other$complained = other.getComplained();
        return !(this$complained == null ? other$complained != null : !((Object)this$complained).equals(other$complained));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZonedDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Accepted $accepted = this.getAccepted();
        result = result * 59 + ($accepted == null ? 43 : ((Object)$accepted).hashCode());
        Delivered $delivered = this.getDelivered();
        result = result * 59 + ($delivered == null ? 43 : ((Object)$delivered).hashCode());
        Failed $failed = this.getFailed();
        result = result * 59 + ($failed == null ? 43 : ((Object)$failed).hashCode());
        StatsTotalValueObject $stored = this.getStored();
        result = result * 59 + ($stored == null ? 43 : ((Object)$stored).hashCode());
        StatsTotalValueObject $opened = this.getOpened();
        result = result * 59 + ($opened == null ? 43 : ((Object)$opened).hashCode());
        StatsTotalValueObject $clicked = this.getClicked();
        result = result * 59 + ($clicked == null ? 43 : ((Object)$clicked).hashCode());
        StatsTotalValueObject $unsubscribed = this.getUnsubscribed();
        result = result * 59 + ($unsubscribed == null ? 43 : ((Object)$unsubscribed).hashCode());
        StatsTotalValueObject $complained = this.getComplained();
        result = result * 59 + ($complained == null ? 43 : ((Object)$complained).hashCode());
        return result;
    }

    public String toString() {
        return "Stats(time=" + this.getTime() + ", accepted=" + this.getAccepted() + ", delivered=" + this.getDelivered() + ", failed=" + this.getFailed() + ", stored=" + this.getStored() + ", opened=" + this.getOpened() + ", clicked=" + this.getClicked() + ", unsubscribed=" + this.getUnsubscribed() + ", complained=" + this.getComplained() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class StatsBuilder {
        private ZonedDateTime time;
        private Accepted accepted;
        private Delivered delivered;
        private Failed failed;
        private StatsTotalValueObject stored;
        private StatsTotalValueObject opened;
        private StatsTotalValueObject clicked;
        private StatsTotalValueObject unsubscribed;
        private StatsTotalValueObject complained;

        StatsBuilder() {
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
        public StatsBuilder time(ZonedDateTime time) {
            this.time = time;
            return this;
        }

        public StatsBuilder accepted(Accepted accepted) {
            this.accepted = accepted;
            return this;
        }

        public StatsBuilder delivered(Delivered delivered) {
            this.delivered = delivered;
            return this;
        }

        public StatsBuilder failed(Failed failed) {
            this.failed = failed;
            return this;
        }

        public StatsBuilder stored(StatsTotalValueObject stored) {
            this.stored = stored;
            return this;
        }

        public StatsBuilder opened(StatsTotalValueObject opened) {
            this.opened = opened;
            return this;
        }

        public StatsBuilder clicked(StatsTotalValueObject clicked) {
            this.clicked = clicked;
            return this;
        }

        public StatsBuilder unsubscribed(StatsTotalValueObject unsubscribed) {
            this.unsubscribed = unsubscribed;
            return this;
        }

        public StatsBuilder complained(StatsTotalValueObject complained) {
            this.complained = complained;
            return this;
        }

        public Stats build() {
            return new Stats(this.time, this.accepted, this.delivered, this.failed, this.stored, this.opened, this.clicked, this.unsubscribed, this.complained);
        }

        public String toString() {
            return "Stats.StatsBuilder(time=" + this.time + ", accepted=" + this.accepted + ", delivered=" + this.delivered + ", failed=" + this.failed + ", stored=" + this.stored + ", opened=" + this.opened + ", clicked=" + this.clicked + ", unsubscribed=" + this.unsubscribed + ", complained=" + this.complained + ")";
        }
    }
}

