/*
 * Decompiled with CFR 0.152.
 */
package com.mailgun.model.templates;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.time.ZonedDateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=TemplateBuilder.class)
public final class Template {
    private final String id;
    private final String name;
    private final String description;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
    private final ZonedDateTime createdAt;
    private final String createdBy;

    Template(String id, String name, String description, ZonedDateTime createdAt, String createdBy) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
    }

    public static TemplateBuilder builder() {
        return new TemplateBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        return !(this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        return result;
    }

    public String toString() {
        return "Template(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", createdAt=" + this.getCreatedAt() + ", createdBy=" + this.getCreatedBy() + ")";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class TemplateBuilder {
        private String id;
        private String name;
        private String description;
        private ZonedDateTime createdAt;
        private String createdBy;

        TemplateBuilder() {
        }

        public TemplateBuilder id(String id) {
            this.id = id;
            return this;
        }

        public TemplateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TemplateBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="EEE, d MMM yyyy HH:mm:ss z", locale="en")
        public TemplateBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public TemplateBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Template build() {
            return new Template(this.id, this.name, this.description, this.createdAt, this.createdBy);
        }

        public String toString() {
            return "Template.TemplateBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ")";
        }
    }
}

