/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.AbstractPollingScheduler;
import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.PollListener;
import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import org.apache.commons.configuration.Configuration;

public class DynamicConfiguration
extends ConcurrentMapConfiguration {
    private AbstractPollingScheduler scheduler;
    private PolledConfigurationSource source;
    public static final int EVENT_RELOAD = 100;

    public DynamicConfiguration(PolledConfigurationSource source, AbstractPollingScheduler scheduler) {
        this();
        this.startPolling(source, scheduler);
    }

    public DynamicConfiguration() {
    }

    public synchronized void startPolling(PolledConfigurationSource source, AbstractPollingScheduler scheduler) {
        this.scheduler = scheduler;
        this.source = source;
        this.init(source, scheduler);
        scheduler.addPollListener(new PollListener(){

            @Override
            public void handleEvent(PollListener.EventType eventType, PollResult lastResult, Throwable exception) {
                switch (eventType) {
                    case POLL_SUCCESS: {
                        DynamicConfiguration.this.fireEvent(100, null, null, false);
                        break;
                    }
                    case POLL_FAILURE: {
                        DynamicConfiguration.this.fireError(100, null, null, exception);
                        break;
                    }
                    case POLL_BEGIN: {
                        DynamicConfiguration.this.fireEvent(100, null, null, true);
                    }
                }
            }
        });
        scheduler.startPolling(source, (Configuration)this);
    }

    protected void init(PolledConfigurationSource source, AbstractPollingScheduler scheduler) {
    }

    public synchronized void stopLoading() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    public PolledConfigurationSource getSource() {
        return this.source;
    }
}

