/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.aws.AwsAsgUtil;
import com.netflix.eureka.registry.AwsInstanceRegistry;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import jakarta.inject.Inject;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{version}/asg")
@Produces(value={"application/xml", "application/json"})
public class ASGResource {
    private static final Logger logger = LoggerFactory.getLogger(ASGResource.class);
    protected final PeerAwareInstanceRegistry registry;
    protected final AwsAsgUtil awsAsgUtil;

    @Inject
    ASGResource(EurekaServerContext eurekaServer) {
        this.registry = eurekaServer.getRegistry();
        this.awsAsgUtil = this.registry instanceof AwsInstanceRegistry ? ((AwsInstanceRegistry)this.registry).getAwsAsgUtil() : null;
    }

    public ASGResource() {
        this(EurekaServerContextHolder.getInstance().getServerContext());
    }

    @PUT
    @Path(value="{asgName}/status")
    public Response statusUpdate(@PathParam(value="asgName") String asgName, @QueryParam(value="value") String newStatus, @HeaderParam(value="x-netflix-discovery-replication") String isReplication) {
        if (this.awsAsgUtil == null) {
            return Response.status((int)400).build();
        }
        try {
            logger.info("Trying to update ASG Status for ASG {} to {}", (Object)asgName, (Object)newStatus);
            ASGStatus asgStatus = ASGStatus.valueOf(newStatus.toUpperCase());
            this.awsAsgUtil.setStatus(asgName, !ASGStatus.DISABLED.equals((Object)asgStatus));
            this.registry.statusUpdate(asgName, asgStatus, Boolean.valueOf(isReplication));
            logger.debug("Updated ASG Status for ASG {} to {}", (Object)asgName, (Object)asgStatus);
        }
        catch (Throwable e) {
            logger.error("Cannot update the status {} for the ASG {}", new Object[]{newStatus, asgName, e});
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    public static enum ASGStatus {
        ENABLED,
        DISABLED;


        public static ASGStatus toEnum(String s) {
            for (ASGStatus e : ASGStatus.values()) {
                if (!e.name().equalsIgnoreCase(s)) continue;
                return e;
            }
            throw new RuntimeException("Cannot find ASG enum for the given string " + s);
        }
    }
}

