/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.Method;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.auth.AuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;

public abstract class AbstractMethod<RequestT, ResultT>
implements Method<RequestT, ResultT> {
    private static final Log LOG = LogFactory.getLog(AbstractMethod.class);
    protected final HttpWrapper httpWrapper;
    private Set<Class> acceptable;

    public AbstractMethod(HttpWrapper httpWrapper) {
        this.httpWrapper = httpWrapper;
    }

    @Override
    public ResultT execute(RequestT request) throws IOException, NexmoClientException {
        try {
            HttpEntityEnclosingRequest entityRequest;
            HttpEntity entity;
            RequestBuilder requestBuilder = this.applyAuth(this.makeRequest(request));
            HttpUriRequest httpRequest = requestBuilder.build();
            if (httpRequest instanceof HttpEntityEnclosingRequest && (entity = (entityRequest = (HttpEntityEnclosingRequest)httpRequest).getEntity()) instanceof UrlEncodedFormEntity) {
                entityRequest.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)requestBuilder.getParameters(), Charset.forName("UTF-8")));
            }
            LOG.debug((Object)("Request: " + httpRequest));
            if (LOG.isDebugEnabled() && httpRequest instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase enclosingRequest = (HttpEntityEnclosingRequestBase)httpRequest;
                LOG.debug((Object)EntityUtils.toString((HttpEntity)enclosingRequest.getEntity()));
            }
            HttpResponse response = this.httpWrapper.getHttpClient().execute(httpRequest);
            return this.parseResponse(response);
        }
        catch (UnsupportedEncodingException uee) {
            throw new NexmoUnexpectedException("UTF-8 encoding is not supported by this JVM.", uee);
        }
    }

    protected RequestBuilder applyAuth(RequestBuilder request) throws NexmoClientException {
        return this.getAuthMethod(this.getAcceptableAuthMethods()).apply(request);
    }

    protected AuthMethod getAuthMethod(Class[] acceptableAuthMethods) throws NexmoClientException {
        if (this.acceptable == null) {
            this.acceptable = new HashSet<Class>();
            Collections.addAll(this.acceptable, acceptableAuthMethods);
        }
        return this.httpWrapper.getAuthCollection().getAcceptableAuthMethod(this.acceptable);
    }

    public void setHttpClient(HttpClient client) {
        this.httpWrapper.setHttpClient(client);
    }

    protected abstract Class[] getAcceptableAuthMethods();

    public abstract RequestBuilder makeRequest(RequestT var1) throws NexmoClientException, UnsupportedEncodingException;

    public abstract ResultT parseResponse(HttpResponse var1) throws IOException, NexmoClientException;
}

