/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.account;

import com.nexmo.client.AbstractClient;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.account.BalanceEndpoint;
import com.nexmo.client.account.BalanceResponse;
import com.nexmo.client.account.CreateSecretRequest;
import com.nexmo.client.account.ListSecretsResponse;
import com.nexmo.client.account.PrefixPricingEndpoint;
import com.nexmo.client.account.PrefixPricingRequest;
import com.nexmo.client.account.PrefixPricingResponse;
import com.nexmo.client.account.PricingEndpoint;
import com.nexmo.client.account.PricingRequest;
import com.nexmo.client.account.PricingResponse;
import com.nexmo.client.account.SecretManagementEndpoint;
import com.nexmo.client.account.SecretRequest;
import com.nexmo.client.account.SecretResponse;
import com.nexmo.client.account.ServiceType;
import com.nexmo.client.account.TopUpEndpoint;
import com.nexmo.client.account.TopUpRequest;
import java.io.IOException;

public class AccountClient
extends AbstractClient {
    protected BalanceEndpoint balance;
    protected PricingEndpoint pricing;
    protected PrefixPricingEndpoint prefixPricing;
    protected TopUpEndpoint topUp;
    protected SecretManagementEndpoint secret;

    public AccountClient(HttpWrapper httpWrapper) {
        super(httpWrapper);
        this.balance = new BalanceEndpoint(httpWrapper);
        this.pricing = new PricingEndpoint(httpWrapper);
        this.prefixPricing = new PrefixPricingEndpoint(httpWrapper);
        this.topUp = new TopUpEndpoint(httpWrapper);
        this.secret = new SecretManagementEndpoint(httpWrapper);
    }

    public BalanceResponse getBalance() throws IOException, NexmoClientException {
        return this.balance.execute();
    }

    public PricingResponse getVoicePrice(String country) throws IOException, NexmoClientException {
        return this.getVoicePrice(new PricingRequest(country));
    }

    private PricingResponse getVoicePrice(PricingRequest pricingRequest) throws IOException, NexmoClientException {
        return this.pricing.getPrice(ServiceType.VOICE, pricingRequest);
    }

    public PricingResponse getSmsPrice(String country) throws IOException, NexmoClientException {
        return this.getSmsPrice(new PricingRequest(country));
    }

    private PricingResponse getSmsPrice(PricingRequest pricingRequest) throws IOException, NexmoClientException {
        return this.pricing.getPrice(ServiceType.SMS, pricingRequest);
    }

    public PrefixPricingResponse getPrefixPrice(ServiceType type, String prefix) throws IOException, NexmoClientException {
        return this.getPrefixPrice(new PrefixPricingRequest(type, prefix));
    }

    private PrefixPricingResponse getPrefixPrice(PrefixPricingRequest prefixPricingRequest) throws IOException, NexmoClientException {
        return this.prefixPricing.getPrice(prefixPricingRequest);
    }

    public void topUp(String transaction) throws IOException, NexmoClientException {
        this.topUp(new TopUpRequest(transaction));
    }

    private void topUp(TopUpRequest request) throws IOException, NexmoClientException {
        this.topUp.topUp(request);
    }

    public ListSecretsResponse listSecrets(String apiKey) throws IOException, NexmoClientException {
        return this.secret.listSecrets(apiKey);
    }

    public SecretResponse getSecret(String apiKey, String secretId) throws IOException, NexmoClientException {
        return this.getSecret(new SecretRequest(apiKey, secretId));
    }

    private SecretResponse getSecret(SecretRequest secretRequest) throws IOException, NexmoClientException {
        return this.secret.getSecret(secretRequest);
    }

    public SecretResponse createSecret(String apiKey, String secret) throws IOException, NexmoClientException {
        return this.createSecret(new CreateSecretRequest(apiKey, secret));
    }

    private SecretResponse createSecret(CreateSecretRequest createSecretRequest) throws IOException, NexmoClientException {
        return this.secret.createSecret(createSecretRequest);
    }

    public void revokeSecret(String apiKey, String secretId) throws IOException, NexmoClientException {
        this.revokeSecret(new SecretRequest(apiKey, secretId));
    }

    private void revokeSecret(SecretRequest secretRequest) throws IOException, NexmoClientException {
        this.secret.revokeSecret(secretRequest);
    }
}

