/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.applications;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.applications.ApplicationDetails;
import com.nexmo.client.applications.CreateApplicationMethod;
import com.nexmo.client.applications.CreateApplicationRequest;
import com.nexmo.client.applications.DeleteApplicationMethod;
import com.nexmo.client.applications.GetApplicationEndpoint;
import com.nexmo.client.applications.ListApplicationsEndpoint;
import com.nexmo.client.applications.ListApplicationsRequest;
import com.nexmo.client.applications.ListApplicationsResponse;
import com.nexmo.client.applications.UpdateApplicationMethod;
import com.nexmo.client.applications.UpdateApplicationRequest;
import java.io.IOException;

class ApplicationsEndpoint {
    private CreateApplicationMethod create;
    private UpdateApplicationMethod update;
    private GetApplicationEndpoint get;
    private ListApplicationsEndpoint list;
    private DeleteApplicationMethod delete;

    ApplicationsEndpoint(HttpWrapper httpWrapper) {
        this.create = new CreateApplicationMethod(httpWrapper);
        this.update = new UpdateApplicationMethod(httpWrapper);
        this.get = new GetApplicationEndpoint(httpWrapper);
        this.list = new ListApplicationsEndpoint(httpWrapper);
        this.delete = new DeleteApplicationMethod(httpWrapper);
    }

    ApplicationDetails post(CreateApplicationRequest request) throws IOException, NexmoClientException {
        return (ApplicationDetails)this.create.execute(request);
    }

    ApplicationDetails put(UpdateApplicationRequest request) throws IOException, NexmoClientException {
        return (ApplicationDetails)this.update.execute(request);
    }

    ApplicationDetails get(String applicationId) throws IOException, NexmoClientException {
        return (ApplicationDetails)this.get.execute(applicationId);
    }

    ListApplicationsResponse get(ListApplicationsRequest request) throws IOException, NexmoClientException {
        return (ListApplicationsResponse)this.list.execute(request);
    }

    void delete(String applicationId) throws IOException, NexmoClientException {
        this.delete.execute(applicationId);
    }
}

