/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.applications;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.ArrayIterator;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.applications.ApplicationDetails;
import com.nexmo.client.applications.EmbeddedApplicationDetails;
import java.io.IOException;
import java.util.Iterator;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ListApplicationsResponse
implements Iterable<ApplicationDetails> {
    private int count;
    private int pageSize;
    private int pageIndex;
    private EmbeddedApplicationDetails embedded;

    public static ListApplicationsResponse fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (ListApplicationsResponse)mapper.readValue(json, ListApplicationsResponse.class);
        }
        catch (IOException jpe) {
            throw new NexmoUnexpectedException("Failed to produce ListApplicationsResponse from json.", jpe);
        }
    }

    public int getCount() {
        return this.count;
    }

    @JsonProperty(value="page_size")
    public int getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="page_index")
    public int getPageIndex() {
        return this.pageIndex;
    }

    @JsonProperty(value="_embedded")
    public EmbeddedApplicationDetails getEmbedded() {
        return this.embedded;
    }

    @Override
    public Iterator<ApplicationDetails> iterator() {
        return new ArrayIterator((Object[])this.embedded.getApplicationDetails());
    }
}

