/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.applications;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.applications.ApplicationDetails;
import com.nexmo.client.applications.UpdateApplicationRequest;
import com.nexmo.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;

class UpdateApplicationMethod
extends AbstractMethod<UpdateApplicationRequest, ApplicationDetails> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/applications/";

    UpdateApplicationMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(UpdateApplicationRequest request) throws NexmoClientException, UnsupportedEncodingException {
        return RequestBuilder.put((String)(this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v1") + PATH + request.getApplicationId())).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(request.toJson(), ContentType.APPLICATION_JSON));
    }

    @Override
    public ApplicationDetails parseResponse(HttpResponse response) throws IOException {
        return ApplicationDetails.fromJson(new BasicResponseHandler().handleResponse(response));
    }

    @Override
    protected RequestBuilder applyAuth(RequestBuilder request) throws NexmoClientException {
        return this.getAuthMethod(this.getAcceptableAuthMethods()).applyAsJsonProperties(request);
    }
}

