/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.applications.ApplicationType;
import org.apache.http.client.methods.RequestBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UpdateApplicationRequest {
    private final String applicationId;
    private final String name;
    private final ApplicationType type;
    private final String answerUrl;
    private final String eventUrl;
    private String answerMethod;
    private String eventMethod;

    public UpdateApplicationRequest(String applicationId, String name, String answerUrl, String eventUrl) {
        this(applicationId, name, ApplicationType.VOICE, answerUrl, null, eventUrl, null);
    }

    public UpdateApplicationRequest(String applicationId, String name, ApplicationType type, String answerUrl, String answerMethod, String eventUrl, String eventMethod) {
        this.applicationId = applicationId;
        this.name = name;
        this.type = type;
        this.answerUrl = answerUrl;
        this.eventUrl = eventUrl;
        this.answerMethod = answerMethod;
        this.eventMethod = eventMethod;
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationType getType() {
        return this.type;
    }

    @JsonProperty(value="answer_url")
    public String getAnswerUrl() {
        return this.answerUrl;
    }

    @JsonProperty(value="event_url")
    public String getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="answer_method")
    public String getAnswerMethod() {
        return this.answerMethod;
    }

    public void setAnswerMethod(String answerMethod) {
        this.answerMethod = answerMethod;
    }

    @JsonProperty(value="event_method")
    public String getEventMethod() {
        return this.eventMethod;
    }

    public void setEventMethod(String eventMethod) {
        this.eventMethod = eventMethod;
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new NexmoUnexpectedException("Failed to produce json from UpdateApplicationRequest object.", jpe);
        }
    }

    public void addParams(RequestBuilder request) {
        request.addParameter("name", this.name).addParameter("type", this.type.toString()).addParameter("answer_url", this.answerUrl).addParameter("event_url", this.eventUrl);
        if (this.eventMethod != null) {
            request.addParameter("event_method", this.eventMethod);
        }
        if (this.answerMethod != null) {
            request.addParameter("answer_method", this.answerMethod);
        }
    }
}

