/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.auth;

import com.nexmo.client.auth.AuthMethod;
import com.nexmo.client.auth.NexmoUnacceptableAuthException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AuthCollection {
    private SortedSet<AuthMethod> authList;

    public AuthCollection() {
        this.authList = new TreeSet<AuthMethod>();
    }

    public AuthCollection(AuthMethod ... authMethods) {
        this();
        for (AuthMethod method : authMethods) {
            this.add(method);
        }
    }

    public AuthCollection(SortedSet<AuthMethod> authMethods) {
        this.authList = authMethods;
    }

    public void add(AuthMethod auth) {
        this.authList.add(auth);
    }

    public <T extends AuthMethod> T getAuth(Class<T> type) throws NexmoUnacceptableAuthException {
        for (AuthMethod availableAuthMethod : this.authList) {
            if (!type.isInstance(availableAuthMethod)) continue;
            return (T)availableAuthMethod;
        }
        throw new NexmoUnacceptableAuthException(this.authList, new HashSet<Class>(Arrays.asList(type)));
    }

    public AuthMethod getAcceptableAuthMethod(Set<Class> acceptableAuthMethodClasses) throws NexmoUnacceptableAuthException {
        for (AuthMethod availableAuthMethod : this.authList) {
            if (!acceptableAuthMethodClasses.contains(availableAuthMethod.getClass())) continue;
            return availableAuthMethod;
        }
        throw new NexmoUnacceptableAuthException(this.authList, acceptableAuthMethodClasses);
    }
}

