/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.conversion;

import com.nexmo.client.AbstractMethod;
import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoBadRequestException;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.SignatureAuthMethod;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.conversion.ConversionRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;

class ConversionMethod
extends AbstractMethod<ConversionRequest, Void> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/conversions/";

    ConversionMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(ConversionRequest conversionRequest) throws NexmoClientException, UnsupportedEncodingException {
        String uri = this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH + conversionRequest.getType().name().toLowerCase();
        return RequestBuilder.post((String)uri).addParameter("message-id", conversionRequest.getMessageId()).addParameter("delivered", String.valueOf(conversionRequest.isDelivered())).addParameter("timestamp", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(conversionRequest.getTimestamp()));
    }

    @Override
    public Void parseResponse(HttpResponse response) throws IOException, NexmoClientException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new NexmoBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return null;
    }

    public String getBaseUri() {
        return this.httpWrapper.getHttpConfig().getApiBaseUri() + PATH;
    }
}

